/*
 * Decompiled with CFR 0.152.
 */
import Aladdin.Hasp;
import Aladdin.HaspApiVersion;
import Aladdin.HaspTime;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

class hasp_demo {
    public static final int DEMO_MEMBUFFER_SIZE = 128;
    public static final String vendorCode = new String("AzIceaqfA1hX5wS+M8cGnYh5ceevUnOZIzJBbXFD6dgf3tBkb9cvUF/Tkd/iKu2fsg9wAysYKw7RMAsVvIp4KcXle/v1RaXrLVnNBJ2H2DmrbUMOZbQUFXe698qmJsqNpLXRA367xpZ54i8kC5DTXwDhfxWTOZrBrh5sRKHcoVLumztIQjgWh37AzmSd1bLOfUGI0xjAL9zJWO3fRaeB0NS2KlmoKaVT5Y04zZEc06waU2r6AU2Dc4uipJqJmObqKM+tfNKAS0rZr5IudRiC7pUwnmtaHRe5fgSI8M7yvypvm+13Wm4Gwd4VnYiZvSxf8ImN3ZOG9wEzfyMIlH2+rKPUVHI+igsqla0Wd9m7ZUR9vFotj1uYV0OzG7hX0+huN2E/IdgLDjbiapj1e2fKHrMmGFaIvI6xzzJIQJF9GiRZ7+0jNFLKSyzX/K3JAyFrIPObfwM+y+zAgE1sWcZ1YnuBhICyRHBhaJDKIZL8MywrEfB2yF+R3k9wFG1oN48gSLyfrfEKuB/qgNp+BeTruWUk0AwRE9XVMUuRbjpxa4YA67SKunFEgFGgUfHBeHJTivvUl0u4Dki1UKAT973P+nXy2O0u239If/kRpNUVhMg8kpk7s8i6Arp7l/705/bLCx4kN5hHHSXIqkiG9tHdeNV8VYo5+72hgaCx3/uVoVLmtvxbOIvo120uTJbuLVTvT8KtsOlb3DxwUrwLzaEMoAQAFk6Q9bNipHxfkRQER4kR7IYTMzSoW5mxh3H9O8Ge5BqVeYMEW36q9wnOYfxOLNw6yQMf8f9sJN4KhZty02xm707S7VEfJJ1KNq7b5pP/3RjE0IKtB2gE6vAPRvRLzEohu0m7q1aUp8wAvSiqjZy7FLaTtLEApXYvLvz6PEJdj4TegCZugj7c8bIOEqLXmloZ6EgVnjQ7/ttys7VFITB3mazzFiyQuKf4J6+b/a/Y");
    public static final String useAuthRuntimeConfig = new String("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n  <haspconfig>\n    <auth_config>\n      <!-- Specify \"1\" to launch Sentinel Authentication Run-time. -->\n      <hasp_auth_rte>1</hasp_auth_rte>\n    </auth_config>\n  </haspconfig>\n");
    public static final String notUseAuthRuntimeConfig = new String("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n  <haspconfig>\n    <auth_config>\n      <!-- Specify \"1\" to launch Sentinel Authentication Run-time. -->\n      <hasp_auth_rte>0</hasp_auth_rte>\n    </auth_config>\n  </haspconfig>\n");
    public static final String localScope = new String("<haspscope>\n <license_manager hostname=\"localhost\" />\n</haspscope>\n");
    public static final String nonCLScope = new String("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n  <haspscope>\n    <hasp cloud_originated=\"false\" />\n  </haspscope>\n");
    public static final String clScope = new String("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n  <haspscope>\n    <hasp cloud_originated=\"true\" />\n  </haspscope>\n");
    private static String scope = localScope;
    public static final String view = new String("<haspformat root=\"my_custom_scope\">\n  <hasp>\n    <attribute name=\"id\" />\n    <attribute name=\"type\" />\n    <feature>\n      <attribute name=\"id\" />\n      <element name=\"concurrency\" />\n      <element name=\"license\" />\n      <session>\n        <element name=\"username\" />\n        <element name=\"hostname\" />\n        <element name=\"ip\" />\n        <element name=\"apiversion\" />\n      </session>\n    </feature>\n  </hasp>\n</haspformat>\n");
    public static final byte[] data = new byte[]{116, 101, 115, 116, 32, 115, 116, 114, 105, 110, 103, 32, 49, 50, 51, 0};
    private static HaspTime datetime;

    hasp_demo() {
    }

    private static void usage() {
        System.out.println("Select access mode:\n");
        System.out.println("See README for prerequisite.\n");
        System.out.println("1. Local only, Enter '1'\n");
        System.out.println("2. Local and local area network, Enter '2'\n");
        System.out.println("3. CL (Identity String-Based Authentication), Enter '3'\n");
        System.out.println("4. CL (OAuth-Based Authentication), Enter '4'\n");
    }

    private static void byte2hex(byte by, StringBuffer stringBuffer) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = (by & 0xF0) >> 4;
        int n2 = by & 0xF;
        stringBuffer.append(cArray[n]);
        stringBuffer.append(cArray[n2]);
    }

    private static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            hasp_demo.byte2hex(byArray[i], stringBuffer);
            if (i >= n - 1) continue;
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }

    public static void dump(byte[] byArray, String string) {
        String string2;
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = new byte[]{0};
        if (byArray.length == 0) {
            return;
        }
        byArray2[0] = 0;
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n2;
            if (n == 0) {
                System.out.print(string);
            }
            byArray2[n] = (n2 = byArray[i]) < 32 || n2 > 127 ? 46 : n2;
            if (n < 15) {
                byArray2[n + 1] = 0;
            }
            byArray3[0] = n2;
            String string3 = hasp_demo.toHexString(byArray3);
            System.out.print(string3 + " ");
            if ((++n & 3) == 0 && n < 15) {
                System.out.print("| ");
            }
            string2 = new String(byArray2);
            if (n <= 15) continue;
            System.out.println("[" + string2 + "]");
            n = 0;
            byArray2[0] = 0;
        }
        if (n != 0) {
            while (n < 16) {
                System.out.print("   ");
                if ((++n & 3) != 0 || n >= 15) continue;
                System.out.print("| ");
            }
            string2 = new String(byArray2);
            System.out.println(" [" + string2 + "]");
        }
    }

    public static void main(String[] stringArray) throws IOException {
        Object object;
        int n = 0;
        int n2 = 48;
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        Hasp hasp = new Hasp(0L);
        Hasp hasp2 = new Hasp(1L);
        Hasp hasp3 = hasp;
        System.out.println("\nThis is a simple demo program for the Sentinel LDK licensing functions\n");
        System.out.println("Copyright (C) THALES. All rights reserved.\n\n");
        hasp_demo.usage();
        n2 = (char)bufferedReader.read();
        switch (n2) {
            case 49: {
                hasp3 = hasp;
                hasp3.config(notUseAuthRuntimeConfig, vendorCode);
                scope = localScope;
                break;
            }
            case 50: {
                hasp3 = hasp;
                hasp3.config(notUseAuthRuntimeConfig, vendorCode);
                scope = nonCLScope;
                break;
            }
            case 51: {
                hasp3 = hasp2;
                hasp3.config(notUseAuthRuntimeConfig, vendorCode);
                scope = clScope;
                break;
            }
            case 52: {
                hasp3 = hasp2;
                hasp3.config(useAuthRuntimeConfig, vendorCode);
                scope = clScope;
                break;
            }
            default: {
                System.out.println("wrong selection. Exit.");
                return;
            }
        }
        int n3 = hasp3.getLastError();
        switch (n3) {
            case 0: {
                System.out.println("OK");
                break;
            }
            case 22: {
                System.out.println("invalid vendor code");
                break;
            }
            case 110: {
                System.out.println("the identity is temporarily not accessible");
                break;
            }
            case 111: {
                System.out.println("cannot use both an identity string and a JWT for the same server address");
                break;
            }
            case 112: {
                System.out.println("the access token is invalid");
                break;
            }
            case 113: {
                System.out.println("the access token has expired");
                break;
            }
            default: {
                System.out.println("hasp config failed");
            }
        }
        HaspApiVersion haspApiVersion = hasp3.getVersion(vendorCode);
        n3 = haspApiVersion.getLastError();
        switch (n3) {
            case 0: {
                break;
            }
            case 400: {
                System.out.println("Sentinel API dynamic library not found");
                return;
            }
            case 401: {
                System.out.println("Sentinel API dynamic library is corrupt");
                return;
            }
            default: {
                System.out.println("unexpected error");
            }
        }
        System.out.println("API Version: " + haspApiVersion.majorVersion() + "." + haspApiVersion.minorVersion() + "." + haspApiVersion.buildNumber() + "\n");
        System.out.println("restricting the license to be used to in a scope:");
        System.out.println(scope);
        System.out.print("hasp_login_scope                 : ");
        hasp3.loginScope(scope, vendorCode);
        n3 = hasp3.getLastError();
        switch (n3) {
            case 0: {
                System.out.println("OK");
                break;
            }
            case 31: {
                System.out.println("no Sentinel DEMOMA key found");
                break;
            }
            case 7: {
                System.out.println("Sentinel key not found");
                break;
            }
            case 11: {
                System.out.println("outdated driver version or no driver installed");
                break;
            }
            case 14: {
                System.out.println("Sentinel key not found");
                break;
            }
            case 22: {
                System.out.println("invalid vendor code");
                break;
            }
            default: {
                System.out.println("login to demo feature failed");
            }
        }
        System.out.print("\nget session info                 : ");
        String string = hasp3.getSessionInfo(Hasp.HASP_KEYINFO);
        n3 = hasp3.getLastError();
        switch (n3) {
            case 0: {
                System.out.print("OK, Sentinel key attributes retrieved\n\nKey info:\n===============\n" + string + "\n===============\n");
                break;
            }
            case 9: {
                System.out.println("handle not active");
                break;
            }
            case 15: {
                System.out.println("unrecognized format");
                break;
            }
            case 7: {
                System.out.println("Sentinel key not found");
                break;
            }
            default: {
                System.out.println("hasp_get_sessioninfo failed");
            }
        }
        System.out.println("\npress ENTER to continue");
        n = bufferedReader.read();
        System.out.println("\nretrieving the key's memory size : ");
        int n4 = hasp3.getSize(65524L);
        n3 = hasp3.getLastError();
        switch (n3) {
            case 0: {
                System.out.println("memory size is " + n4 + " bytes");
                break;
            }
            case 9: {
                System.out.println("handle not active");
                break;
            }
            case 10: {
                System.out.println("invalid file id");
                break;
            }
            case 7: {
                System.out.println("Sentinel key not found");
                break;
            }
            default: {
                System.out.println("could not retrieve memory size");
            }
        }
        if (n4 != 0) {
            if (n4 > 128) {
                n4 = 128;
            }
            System.out.println("\nreading " + n4 + " bytes from memory   : ");
            object = new byte[128];
            hasp3.read(65524L, 0, (byte[])object);
            n3 = hasp3.getLastError();
            switch (n3) {
                case 0: {
                    System.out.println("OK");
                    hasp_demo.dump((byte[])object, "    ");
                    break;
                }
                case 9: {
                    System.out.println("handle not active");
                    break;
                }
                case 10: {
                    System.out.println("invalid file id");
                    break;
                }
                case 1: {
                    System.out.println("beyond memory range of attached Sentinel key");
                    break;
                }
                case 7: {
                    System.out.println("hasp not found");
                    break;
                }
                default: {
                    System.out.println("read memory failed\n");
                }
            }
            System.out.println("\nincrementing every byte in memory buffer");
            int n5 = 0;
            while (n5 < n4) {
                int n6 = n5++;
                object[n6] = (byte)(object[n6] + 1);
            }
            System.out.println("\nwriting " + n4 + " bytes to memory     : ");
            hasp3.write(65524L, 0, (byte[])object);
            n3 = hasp3.getLastError();
            switch (n3) {
                case 0: {
                    System.out.println("OK");
                    break;
                }
                case 9: {
                    System.out.println("handle not active");
                    break;
                }
                case 10: {
                    System.out.println("invalid file id");
                    break;
                }
                case 1: {
                    System.out.println("beyond memory range of attached Sentinel key");
                    break;
                }
                case 7: {
                    System.out.println("Sentinel key not found");
                    break;
                }
                default: {
                    System.out.println("write memory failed");
                }
            }
            System.out.println("\nreading " + n4 + " bytes from memory   : ");
            hasp3.read(65524L, 0, (byte[])object);
            switch (n3) {
                case 0: {
                    System.out.println("OK");
                    hasp_demo.dump((byte[])object, "    ");
                    break;
                }
                case 9: {
                    System.out.println("handle not active\n");
                    break;
                }
                case 10: {
                    System.out.println("invalid file id");
                    break;
                }
                case 1: {
                    System.out.println("beyond memory range of attached Sentinel key");
                    break;
                }
                case 7: {
                    System.out.println("Sentinel key not found");
                    break;
                }
                default: {
                    System.out.println("read memory failed");
                }
            }
        }
        System.out.println("\nencrypting a data buffer:");
        hasp_demo.dump(data, "     ");
        hasp3.encrypt(data);
        n3 = hasp3.getLastError();
        switch (n3) {
            case 0: {
                System.out.println("encryption ok:");
                hasp_demo.dump(data, "     ");
                break;
            }
            case 9: {
                System.out.println("handle not active");
                break;
            }
            case 8: {
                System.out.println("data length too short");
                break;
            }
            case 23: {
                System.out.println("attached key does not support AES encryption");
                break;
            }
            case 31: {
                System.out.println("Sentinel key not found");
                break;
            }
            default: {
                System.out.println("encryption failed");
            }
        }
        hasp3.decrypt(data);
        n3 = hasp3.getLastError();
        switch (n3) {
            case 0: {
                System.out.println("decryption ok:");
                hasp_demo.dump(data, "     ");
                break;
            }
            case 9: {
                System.out.println("handle not active");
                break;
            }
            case 8: {
                System.out.println("data length too short");
                break;
            }
            case 23: {
                System.out.println("attached key does not support AES encryption");
                break;
            }
            case 31: {
                System.out.println("key not found");
                break;
            }
            default: {
                System.out.println("decryption failed");
            }
        }
        if (n2 == 49 || n2 == 50) {
            System.out.print("login to feature 42              : ");
            object = new Hasp(42L);
            ((Hasp)object).loginScope(scope, vendorCode);
            n3 = ((Hasp)object).getLastError();
            switch (n3) {
                case 0: {
                    System.out.println("OK");
                    break;
                }
                case 31: {
                    System.out.println("no Sentinel DEMOMA key found with feature 42 enabled");
                    break;
                }
                case 7: {
                    System.out.println("Sentinel key not found");
                    break;
                }
                case 11: {
                    System.out.println("outdated driver version or no driver installed");
                    break;
                }
                case 14: {
                    System.out.println("Sentinel key not found");
                    break;
                }
                case 22: {
                    System.out.println("invalid vendor code");
                    break;
                }
                default: {
                    System.out.println("login feature 42 failed");
                }
            }
            System.out.println("\nencrypt/decrypt again to see different encryption for different features:");
            System.out.println("\nencrypting a data buffer:");
            hasp_demo.dump(data, "     ");
            ((Hasp)object).encrypt(data);
            n3 = ((Hasp)object).getLastError();
            switch (n3) {
                case 0: {
                    System.out.println("encryption ok:");
                    hasp_demo.dump(data, "     ");
                    break;
                }
                case 9: {
                    System.out.println("handle not active");
                    break;
                }
                case 8: {
                    System.out.println("data length too short");
                    break;
                }
                case 23: {
                    System.out.println("attached key does not support AES encryption");
                    break;
                }
                case 31: {
                    System.out.println("key not found");
                    break;
                }
                default: {
                    System.out.println("encryption failed");
                }
            }
            ((Hasp)object).decrypt(data);
            n3 = ((Hasp)object).getLastError();
            switch (n3) {
                case 0: {
                    System.out.println("decryption ok:");
                    hasp_demo.dump(data, "     ");
                    break;
                }
                case 9: {
                    System.out.println("handle not active");
                    break;
                }
                case 8: {
                    System.out.println("data length too short");
                    break;
                }
                case 23: {
                    System.out.println("attached key does not support AES encryption");
                    break;
                }
                case 31: {
                    System.out.println("key not found");
                    break;
                }
                default: {
                    System.out.println("decryption failed");
                }
            }
            ((Hasp)object).logout();
            n3 = ((Hasp)object).getLastError();
            switch (n3) {
                case 0: {
                    System.out.println("OK");
                    break;
                }
                case 9: {
                    System.out.println("failed: handle not active");
                    break;
                }
                default: {
                    System.out.println("failed with status " + n3);
                }
            }
        }
        System.out.print("\nreading current time and date    : ");
        datetime = hasp3.getRealTimeClock();
        n3 = hasp3.getLastError();
        switch (n3) {
            case 0: {
                System.out.println("time: " + datetime.getHour() + ":" + datetime.getMinute() + ":" + datetime.getSecond() + " H:M:S");
                System.out.println("                                   date: " + datetime.getDay() + "/" + datetime.getMonth() + "/" + datetime.getYear() + " D/M/Y");
                break;
            }
            case 24: {
                System.out.println("time value outside supported range\n");
                break;
            }
            case 9: {
                System.out.println("handle not active");
                break;
            }
            case 12: {
                System.out.println("no Sentinel Time connected");
                break;
            }
            default: {
                System.out.println("could not read time from Sentinel key");
            }
        }
        System.out.print("\nlogout from demo feature            : ");
        hasp3.logout();
        n3 = hasp3.getLastError();
        switch (n3) {
            case 0: {
                System.out.println("OK");
                break;
            }
            case 9: {
                System.out.println("failed: handle not active");
                break;
            }
            default: {
                System.out.println("failed");
            }
        }
        if (n2 == 49 || n2 == 50) {
            hasp3 = new Hasp(0L);
            System.out.print("login to default feature         : ");
            hasp3.login(vendorCode);
            n3 = hasp3.getLastError();
            switch (n3) {
                case 0: {
                    System.out.println("OK");
                    break;
                }
                case 31: {
                    System.out.println("login to default feature failed");
                    break;
                }
                case 7: {
                    System.out.println("Sentinel key not found");
                    break;
                }
                case 11: {
                    System.out.println("outdated driver version or no driver installed");
                    break;
                }
                case 14: {
                    System.out.println("Sentinel key not found");
                    break;
                }
                case 22: {
                    System.out.println("invalid vendor code");
                    break;
                }
                case 36: {
                    System.out.println("invalid XML scope");
                    break;
                }
                default: {
                    System.out.println("login to default feature failed with status " + n3);
                }
            }
            System.out.print("\ngetting information about connected keys and usage:  ");
            string = hasp3.getInfo(nonCLScope, view, vendorCode);
            n3 = hasp3.getLastError();
            switch (n3) {
                case 0: {
                    System.out.println("OK\n" + string);
                    break;
                }
                case 15: {
                    System.out.println("invalid XML info format\n");
                    break;
                }
                case 36: {
                    System.out.println("invalid XML scope\n");
                    break;
                }
                default: {
                    System.out.println("hasp_get_info failed with status " + n3);
                }
            }
            System.out.print("\nlogout                           : ");
            hasp3.logout();
            n3 = hasp3.getLastError();
            switch (n3) {
                case 0: {
                    System.out.println("OK");
                    break;
                }
                case 9: {
                    System.out.println("failed: handle not active");
                    break;
                }
                default: {
                    System.out.println("failed\n");
                }
            }
        }
    }
}

