/*
 * Decompiled with CFR 0.152.
 */
package com.sfnt.ldk.api;

import com.google.gson.Gson;
import com.sfnt.ldk.model.ErrorInfo;
import com.sfnt.ldk.model.FeaturesResponse;
import com.sfnt.ldk.model.KeysResponse;
import com.sfnt.ldk.model.LicenseRequest;
import com.sfnt.ldk.model.LicenseResponse;
import com.sfnt.ldk.model.LogoutResponse;
import com.sfnt.ldk.model.MemoriesResponse;
import com.sfnt.ldk.model.ProductsResponse;
import com.sfnt.ldk.model.ReadMemoryResponse;
import com.sfnt.ldk.util.HmacSHA256Util;
import com.sfnt.ldk.util.ServiceUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;

public class LdkRuntimeRestAPI {
    private static final int TIMEOUT = 30000;
    private static final String URL_COMMON = "/sentinel/ldk_runtime/v1/vendors/";
    private static final String DEFALUT_SECRET = "X-LDK-Identity-WS-V1";
    private static final String PAGE_INDEX = "pageStartIndex=";
    private static final String PAGE_SIZE = "&pageSize=";
    private static final int TOO_MANY_REQUEST = 429;
    private static final String LDK_HEADER = "X-LDK-Instance";
    private static final String HEADER_AUTHORIZATION_IDENTITY = "X-LDK-Identity-WS";
    private static final String HEADER_USER_ID = "X-LDK-User-Id";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String MEMORY_ID = "memoryId=";
    private static final String OFFSET = "&offset=";
    private static final String LENGTH = "&length=";
    private static final Log log = LogFactory.getLog(LdkRuntimeRestAPI.class);
    String serverUrl = "";
    String serverPort = "";
    String identityId = "";
    String identitySecret = "";
    String vendorId = "";
    String sessionId = "";
    String userId = "";
    String accessToken = "";
    long retryAfterTime = 0L;
    String instanceId = "";
    String cookieHeader = "";
    CookieStore cookieStore;
    String[] header;

    public LdkRuntimeRestAPI(String string, String string2, String string3, String string4, String string5) {
        Object object;
        if (string2 != null) {
            object = string2.split("@");
            if (((String[])object).length == 2) {
                String string6;
                String[] stringArray;
                if (string4 == null || string4.isEmpty()) {
                    string4 = object[1];
                }
                if ((stringArray = (string6 = object[0]).split(":")).length == 2) {
                    this.identityId = stringArray[0];
                    this.identitySecret = stringArray[1];
                }
            } else {
                String[] stringArray = string2.split(":");
                if (stringArray.length == 2) {
                    this.identityId = stringArray[0];
                    this.identitySecret = stringArray[1];
                }
            }
        }
        this.vendorId = string;
        this.serverUrl = string5 != null && !string5.isEmpty() ? string3 + "://" + string4 + ":" + string5 + URL_COMMON + string : string3 + "://" + string4 + URL_COMMON + string;
        this.instanceId = UUID.randomUUID().toString();
        object = HttpClientContext.create();
        this.cookieStore = new BasicCookieStore();
        ((HttpClientContext)object).setCookieStore(this.cookieStore);
        this.header = new String[]{HEADER_AUTHORIZATION_IDENTITY};
    }

    public LdkRuntimeRestAPI(String string, String string2, String string3, String string4, String string5, String string6) {
        this.vendorId = string;
        this.userId = string3;
        this.accessToken = string2;
        this.serverUrl = string6 != null && !string6.isEmpty() ? string4 + "://" + string5 + ":" + string6 + URL_COMMON + string : string4 + "://" + string5 + URL_COMMON + string;
        this.instanceId = UUID.randomUUID().toString();
        HttpClientContext httpClientContext = HttpClientContext.create();
        this.cookieStore = new BasicCookieStore();
        httpClientContext.setCookieStore(this.cookieStore);
        this.header = new String[]{HEADER_USER_ID, HEADER_AUTHORIZATION};
    }

    private Map<String, String> createMapHeaders(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        block12: for (int i = 0; i < this.header.length; ++i) {
            switch (this.header[i]) {
                case "X-LDK-Identity-WS": {
                    try {
                        if (this.identitySecret.isEmpty()) continue block12;
                        hashMap.put(HEADER_AUTHORIZATION_IDENTITY, this.generateHeaderValue(string, string2));
                    }
                    catch (Exception exception) {
                        log.error((Object)("Create headers failed with Exception :" + exception.getMessage()));
                    }
                    continue block12;
                }
                case "X-LDK-User-Id": {
                    hashMap.put(HEADER_USER_ID, this.userId);
                    continue block12;
                }
                case "Authorization": {
                    hashMap.put(HEADER_AUTHORIZATION, "Bearer " + this.accessToken);
                }
            }
        }
        return hashMap;
    }

    void getCookiesFromResponse(CloseableHttpResponse closeableHttpResponse) {
        Header[] headerArray = closeableHttpResponse.getHeaders("set-cookie");
        if (headerArray.length > 0) {
            this.cookieHeader = headerArray[0].getValue();
        }
    }

    void setRetryAfterTime(CloseableHttpResponse closeableHttpResponse) {
        Header[] headerArray = closeableHttpResponse.getHeaders("Retry-After");
        if (headerArray != null && headerArray.length > 0) {
            this.retryAfterTime = Integer.parseInt(headerArray[0].getValue()) * 1000;
        }
        log.error((Object)"Failed with too many request at server side.");
    }

    void isNeedToWait() throws InterruptedException {
        if (this.retryAfterTime != 0L) {
            log.info((Object)("Need to wait for " + this.retryAfterTime / 1000L + " seconds"));
            Thread.sleep(this.retryAfterTime);
            this.retryAfterTime = 0L;
        }
    }

    public String getCurrentDate() {
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        simpleDateFormat.setTimeZone(timeZone);
        return simpleDateFormat.format(new Date());
    }

    private String generateHeaderValue(String string, String string2) throws Exception {
        String string3 = "";
        if (!this.identitySecret.isEmpty()) {
            String string4 = this.getCurrentDate();
            String string5 = this.identityId + string4 + URL_COMMON + this.vendorId + string + "^" + string2;
            String string6 = this.generateSignature(this.identitySecret, string5);
            string3 = "V1, Identity=" + this.identityId + ", RequestDate=" + string4 + ", Signature=" + string6;
        }
        return string3;
    }

    private String generateSignature(String string, String string2) throws Exception {
        byte[] byArray = HmacSHA256Util.hmacSHA256(string.getBytes(), DEFALUT_SECRET.getBytes());
        return HmacSHA256Util.byteArrayToHexString(HmacSHA256Util.hmacSHA256(byArray, string2.getBytes()));
    }

    private void handleErrorInfo(CloseableHttpResponse closeableHttpResponse) throws Exception {
        Gson gson = new Gson();
        String string = ServiceUtil.getDataFromResponse(closeableHttpResponse);
        ErrorInfo errorInfo = (ErrorInfo)gson.fromJson(string, ErrorInfo.class);
        throw new Exception(errorInfo.getMessage() + ", X-LDK-Trace-Id:" + closeableHttpResponse.getHeaders("X-LDK-Trace-Id")[0].getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LicenseResponse login(LicenseRequest licenseRequest) throws Exception {
        LicenseResponse licenseResponse = null;
        String string = this.serverUrl + "/sessions";
        String string2 = "";
        CloseableHttpClient closeableHttpClient = ServiceUtil.createHttpClient(string);
        HttpPost httpPost = ServiceUtil.createHttpPost(30000, string, licenseRequest.toString(), this.createMapHeaders("/sessions", licenseRequest.toString()));
        httpPost.setHeader(LDK_HEADER, this.instanceId);
        if (this.cookieHeader != null && !this.cookieHeader.isEmpty()) {
            httpPost.addHeader("Cookie", this.cookieHeader);
        }
        this.isNeedToWait();
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            closeableHttpResponse = closeableHttpClient.execute(httpPost);
            if (closeableHttpResponse != null) {
                if (closeableHttpResponse.getStatusLine().getStatusCode() == 200 || closeableHttpResponse.getStatusLine().getStatusCode() == 201) {
                    string2 = ServiceUtil.getDataFromResponse(closeableHttpResponse);
                    Gson gson = new Gson();
                    licenseResponse = (LicenseResponse)gson.fromJson(string2, LicenseResponse.class);
                    this.sessionId = licenseResponse.getSessionId();
                    this.getCookiesFromResponse(closeableHttpResponse);
                } else {
                    if (closeableHttpResponse.getStatusLine().getStatusCode() == 401) {
                        String string3 = "Login failed with status = " + closeableHttpResponse.getStatusLine().getStatusCode();
                        log.error((Object)string3);
                        throw new Exception(string3);
                    }
                    if (closeableHttpResponse.getStatusLine().getStatusCode() == 429) {
                        this.setRetryAfterTime(closeableHttpResponse);
                    } else {
                        this.handleErrorInfo(closeableHttpResponse);
                    }
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)("Login failed with Exception :" + exception.getMessage()));
        }
        finally {
            ServiceUtil.closeHttpClient(closeableHttpClient, closeableHttpResponse);
        }
        return licenseResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogoutResponse logout() throws Exception {
        LogoutResponse logoutResponse = null;
        String string = "/sessions/" + this.sessionId;
        String string2 = this.serverUrl + string;
        String string3 = "";
        CloseableHttpClient closeableHttpClient = ServiceUtil.createHttpClient(string2);
        HttpDelete httpDelete = ServiceUtil.createHttpDelete(30000, string2, this.createMapHeaders(string, ""));
        httpDelete.setHeader(LDK_HEADER, this.instanceId);
        if (this.cookieHeader != null && !this.cookieHeader.isEmpty()) {
            httpDelete.addHeader("Cookie", this.cookieHeader);
        }
        this.isNeedToWait();
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            closeableHttpResponse = closeableHttpClient.execute(httpDelete);
            if (closeableHttpResponse != null) {
                if (closeableHttpResponse.getStatusLine().getStatusCode() == 200 || closeableHttpResponse.getStatusLine().getStatusCode() == 201) {
                    string3 = ServiceUtil.getDataFromResponse(closeableHttpResponse);
                    Gson gson = new Gson();
                    logoutResponse = (LogoutResponse)gson.fromJson(string3, LogoutResponse.class);
                    this.getCookiesFromResponse(closeableHttpResponse);
                } else {
                    if (closeableHttpResponse.getStatusLine().getStatusCode() == 401) {
                        String string4 = "Logout failed with status = " + closeableHttpResponse.getStatusLine().getStatusCode();
                        log.error((Object)string4);
                        throw new Exception(string4);
                    }
                    if (closeableHttpResponse.getStatusLine().getStatusCode() == 429) {
                        this.setRetryAfterTime(closeableHttpResponse);
                    } else {
                        this.handleErrorInfo(closeableHttpResponse);
                    }
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)("Logout failed with Exception :" + exception.getMessage()));
        }
        finally {
            ServiceUtil.closeHttpClient(closeableHttpClient, closeableHttpResponse);
        }
        return logoutResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LicenseResponse refreshSession() throws Exception {
        LicenseResponse licenseResponse = null;
        String string = "/sessions/" + this.sessionId + "/refresh";
        String string2 = this.serverUrl + string;
        String string3 = "";
        CloseableHttpClient closeableHttpClient = ServiceUtil.createHttpClient(string2);
        HttpPost httpPost = ServiceUtil.createHttpPost(30000, string2, "", this.createMapHeaders(string, ""));
        httpPost.setHeader(LDK_HEADER, this.instanceId);
        if (this.cookieHeader != null && !this.cookieHeader.isEmpty()) {
            httpPost.addHeader("Cookie", this.cookieHeader);
        }
        this.isNeedToWait();
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            closeableHttpResponse = closeableHttpClient.execute(httpPost);
            if (closeableHttpResponse != null) {
                if (closeableHttpResponse.getStatusLine().getStatusCode() == 200 || closeableHttpResponse.getStatusLine().getStatusCode() == 201) {
                    string3 = ServiceUtil.getDataFromResponse(closeableHttpResponse);
                    Gson gson = new Gson();
                    licenseResponse = (LicenseResponse)gson.fromJson(string3, LicenseResponse.class);
                    this.getCookiesFromResponse(closeableHttpResponse);
                } else {
                    if (closeableHttpResponse.getStatusLine().getStatusCode() == 401) {
                        String string4 = "Refresh session failed with status = " + closeableHttpResponse.getStatusLine().getStatusCode();
                        log.error((Object)string4);
                        throw new Exception(string4);
                    }
                    if (closeableHttpResponse.getStatusLine().getStatusCode() == 429) {
                        this.setRetryAfterTime(closeableHttpResponse);
                    } else {
                        this.handleErrorInfo(closeableHttpResponse);
                    }
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)("Refresh session failed with Exception :" + exception.getMessage()));
        }
        finally {
            ServiceUtil.closeHttpClient(closeableHttpClient, closeableHttpResponse);
        }
        return licenseResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeysResponse getKeyList(int n, int n2) throws Exception {
        KeysResponse keysResponse = null;
        String string = "/keys";
        String string2 = this.serverUrl + string + "?" + PAGE_INDEX + n + PAGE_SIZE + n2;
        String string3 = "";
        CloseableHttpClient closeableHttpClient = ServiceUtil.createHttpClient(string2);
        HttpGet httpGet = ServiceUtil.createHttpGet(30000, string2, this.createMapHeaders(string, ""));
        httpGet.setHeader(LDK_HEADER, this.instanceId);
        if (this.cookieHeader != null && !this.cookieHeader.isEmpty()) {
            httpGet.addHeader("Cookie", this.cookieHeader);
        }
        this.isNeedToWait();
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            closeableHttpResponse = closeableHttpClient.execute(httpGet);
            if (closeableHttpResponse != null) {
                if (closeableHttpResponse.getStatusLine().getStatusCode() == 200) {
                    string3 = ServiceUtil.getDataFromResponse(closeableHttpResponse);
                    Gson gson = new Gson();
                    keysResponse = (KeysResponse)gson.fromJson(string3, KeysResponse.class);
                    this.getCookiesFromResponse(closeableHttpResponse);
                } else {
                    if (closeableHttpResponse.getStatusLine().getStatusCode() == 401) {
                        String string4 = "Get key list failed with status = " + closeableHttpResponse.getStatusLine().getStatusCode();
                        log.error((Object)string4);
                        throw new Exception(string4);
                    }
                    if (closeableHttpResponse.getStatusLine().getStatusCode() == 429) {
                        this.setRetryAfterTime(closeableHttpResponse);
                    } else {
                        this.handleErrorInfo(closeableHttpResponse);
                    }
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)("Get key list failed with Exception :" + exception.getMessage()));
        }
        finally {
            ServiceUtil.closeHttpClient(closeableHttpClient, closeableHttpResponse);
        }
        return keysResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProductsResponse getProudctList(int n, int n2) throws Exception {
        ProductsResponse productsResponse = null;
        String string = "/products";
        String string2 = this.serverUrl + string + "?" + PAGE_INDEX + n + PAGE_SIZE + n2;
        String string3 = "";
        CloseableHttpClient closeableHttpClient = ServiceUtil.createHttpClient(string2);
        HttpGet httpGet = ServiceUtil.createHttpGet(30000, string2, this.createMapHeaders(string, ""));
        httpGet.setHeader(LDK_HEADER, this.instanceId);
        if (this.cookieHeader != null && !this.cookieHeader.isEmpty()) {
            httpGet.addHeader("Cookie", this.cookieHeader);
        }
        this.isNeedToWait();
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            closeableHttpResponse = closeableHttpClient.execute(httpGet);
            if (closeableHttpResponse != null) {
                if (closeableHttpResponse.getStatusLine().getStatusCode() == 200) {
                    string3 = ServiceUtil.getDataFromResponse(closeableHttpResponse);
                    Gson gson = new Gson();
                    productsResponse = (ProductsResponse)gson.fromJson(string3, ProductsResponse.class);
                    this.getCookiesFromResponse(closeableHttpResponse);
                } else {
                    if (closeableHttpResponse.getStatusLine().getStatusCode() == 401) {
                        String string4 = "Get product list failed with status = " + closeableHttpResponse.getStatusLine().getStatusCode();
                        log.error((Object)string4);
                        throw new Exception(string4);
                    }
                    if (closeableHttpResponse.getStatusLine().getStatusCode() == 429) {
                        this.setRetryAfterTime(closeableHttpResponse);
                    } else {
                        this.handleErrorInfo(closeableHttpResponse);
                    }
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)("Get product list failed with Exception :" + exception.getMessage()));
        }
        finally {
            ServiceUtil.closeHttpClient(closeableHttpClient, closeableHttpResponse);
        }
        return productsResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeaturesResponse getFeatureList(int n, int n2) throws Exception {
        FeaturesResponse featuresResponse = null;
        String string = "/features";
        String string2 = this.serverUrl + string + "?" + PAGE_INDEX + n + PAGE_SIZE + n2;
        String string3 = "";
        CloseableHttpClient closeableHttpClient = ServiceUtil.createHttpClient(string2);
        HttpGet httpGet = ServiceUtil.createHttpGet(30000, string2, this.createMapHeaders(string, ""));
        httpGet.setHeader(LDK_HEADER, this.instanceId);
        if (this.cookieHeader != null && !this.cookieHeader.isEmpty()) {
            httpGet.addHeader("Cookie", this.cookieHeader);
        }
        this.isNeedToWait();
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            closeableHttpResponse = closeableHttpClient.execute(httpGet);
            if (closeableHttpResponse != null) {
                if (closeableHttpResponse.getStatusLine().getStatusCode() == 200) {
                    string3 = ServiceUtil.getDataFromResponse(closeableHttpResponse);
                    Gson gson = new Gson();
                    featuresResponse = (FeaturesResponse)gson.fromJson(string3, FeaturesResponse.class);
                    this.getCookiesFromResponse(closeableHttpResponse);
                } else {
                    if (closeableHttpResponse.getStatusLine().getStatusCode() == 401) {
                        String string4 = "Get feature list failed with status = " + closeableHttpResponse.getStatusLine().getStatusCode();
                        log.error((Object)string4);
                        throw new Exception(string4);
                    }
                    if (closeableHttpResponse.getStatusLine().getStatusCode() == 429) {
                        this.setRetryAfterTime(closeableHttpResponse);
                    } else {
                        this.handleErrorInfo(closeableHttpResponse);
                    }
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)("Get feature list failed with Exception :" + exception.getMessage()));
        }
        finally {
            ServiceUtil.closeHttpClient(closeableHttpClient, closeableHttpResponse);
        }
        return featuresResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoriesResponse getMemoryList(int n, int n2) throws Exception {
        MemoriesResponse memoriesResponse = null;
        String string = "/memories";
        String string2 = this.serverUrl + string + "?" + PAGE_INDEX + n + PAGE_SIZE + n2;
        String string3 = "";
        CloseableHttpClient closeableHttpClient = ServiceUtil.createHttpClient(string2);
        HttpGet httpGet = ServiceUtil.createHttpGet(30000, string2, this.createMapHeaders(string, ""));
        httpGet.setHeader(LDK_HEADER, this.instanceId);
        if (this.cookieHeader != null && !this.cookieHeader.isEmpty()) {
            httpGet.addHeader("Cookie", this.cookieHeader);
        }
        this.isNeedToWait();
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            closeableHttpResponse = closeableHttpClient.execute(httpGet);
            if (closeableHttpResponse != null) {
                if (closeableHttpResponse.getStatusLine().getStatusCode() == 200) {
                    string3 = ServiceUtil.getDataFromResponse(closeableHttpResponse);
                    Gson gson = new Gson();
                    memoriesResponse = (MemoriesResponse)gson.fromJson(string3, MemoriesResponse.class);
                    this.getCookiesFromResponse(closeableHttpResponse);
                } else {
                    if (closeableHttpResponse.getStatusLine().getStatusCode() == 401) {
                        String string4 = "Get memory list failed with status = " + closeableHttpResponse.getStatusLine().getStatusCode();
                        log.error((Object)string4);
                        throw new Exception(string4);
                    }
                    if (closeableHttpResponse.getStatusLine().getStatusCode() == 429) {
                        this.setRetryAfterTime(closeableHttpResponse);
                    } else {
                        this.handleErrorInfo(closeableHttpResponse);
                    }
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)("Get memory list failed with Exception :" + exception.getMessage()));
        }
        finally {
            ServiceUtil.closeHttpClient(closeableHttpClient, closeableHttpResponse);
        }
        return memoriesResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadMemoryResponse readMemory(int n, int n2, int n3) throws Exception {
        ReadMemoryResponse readMemoryResponse = null;
        String string = "/sessions/" + this.sessionId + "/read";
        String string2 = this.serverUrl + string + "?" + MEMORY_ID + n + OFFSET + n2 + LENGTH + n3;
        String string3 = "";
        CloseableHttpClient closeableHttpClient = ServiceUtil.createHttpClient(string2);
        HttpGet httpGet = ServiceUtil.createHttpGet(30000, string2, this.createMapHeaders(string, ""));
        httpGet.setHeader(LDK_HEADER, this.instanceId);
        if (this.cookieHeader != null && !this.cookieHeader.isEmpty()) {
            httpGet.addHeader("Cookie", this.cookieHeader);
        }
        this.isNeedToWait();
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            closeableHttpResponse = closeableHttpClient.execute(httpGet);
            if (closeableHttpResponse != null) {
                if (closeableHttpResponse.getStatusLine().getStatusCode() == 200) {
                    string3 = ServiceUtil.getDataFromResponse(closeableHttpResponse);
                    Gson gson = new Gson();
                    readMemoryResponse = (ReadMemoryResponse)gson.fromJson(string3, ReadMemoryResponse.class);
                    this.getCookiesFromResponse(closeableHttpResponse);
                } else {
                    if (closeableHttpResponse.getStatusLine().getStatusCode() == 401) {
                        String string4 = "Read memory failed with status = " + closeableHttpResponse.getStatusLine().getStatusCode();
                        log.error((Object)string4);
                        throw new Exception(string4);
                    }
                    if (closeableHttpResponse.getStatusLine().getStatusCode() == 429) {
                        this.setRetryAfterTime(closeableHttpResponse);
                    } else {
                        this.handleErrorInfo(closeableHttpResponse);
                    }
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)("Read memory failed with Exception :" + exception.getMessage()));
        }
        finally {
            ServiceUtil.closeHttpClient(closeableHttpClient, closeableHttpResponse);
        }
        return readMemoryResponse;
    }
}

