/*
 * Decompiled with CFR 0.152.
 */
package com.sfnt.ldk.sample;

import com.google.gson.Gson;
import com.sfnt.ldk.api.LdkRuntimeRestAPI;
import com.sfnt.ldk.model.ClientInfo;
import com.sfnt.ldk.model.FeaturesResponse;
import com.sfnt.ldk.model.KeysResponse;
import com.sfnt.ldk.model.LicenseRequest;
import com.sfnt.ldk.model.LicenseResponse;
import com.sfnt.ldk.model.LogoutResponse;
import com.sfnt.ldk.model.MemoriesResponse;
import com.sfnt.ldk.model.ProductsResponse;
import com.sfnt.ldk.model.ReadMemoryResponse;
import com.sfnt.ldk.model.Scope;
import com.sfnt.ldk.sample.AccessTokenInfo;
import com.sfnt.ldk.util.ServiceUtil;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class Sample {
    private static String clientIdentity = "";
    private static String vendorId = "37515";
    private static String featureId = "0";
    private static String endpointScheme = "http";
    private static String serverAddr = "localhost";
    private static String serverPort = "1947";
    private static String userName = "";
    private static String keyId = "";
    private static String productId = "";
    private static String userId = "";
    private static String clientId = "";
    private static String clientSecret = "";
    private static String accessTokenUrl = "";
    private static String authType = "";
    private static String memoryId = "";
    private static String offset = "";
    private static String length = "";
    private static Boolean fullInfo = false;

    public static void loadProperties() throws Exception {
        Properties properties = new Properties();
        InputStream inputStream = ServiceUtil.getInputStream("configure.properties");
        properties.load(inputStream);
        vendorId = properties.getProperty("vendorId");
        clientIdentity = properties.getProperty("clientIdentity");
        featureId = properties.getProperty("featureId");
        keyId = properties.getProperty("keyId");
        productId = properties.getProperty("productId");
        endpointScheme = properties.getProperty("endpointScheme");
        serverAddr = properties.getProperty("serverAddr");
        serverPort = properties.getProperty("serverPort");
        authType = properties.getProperty("authType");
        userId = properties.getProperty("userId");
        clientId = properties.getProperty("clientId");
        clientSecret = properties.getProperty("clientSecret");
        accessTokenUrl = properties.getProperty("accessTokenUrl");
        if (properties.getProperty("fullInfo") != null && properties.getProperty("fullInfo").equalsIgnoreCase("true")) {
            fullInfo = true;
        }
        userName = System.getProperty("user.name");
        memoryId = properties.getProperty("memoryId");
        offset = properties.getProperty("offset");
        length = properties.getProperty("length");
    }

    public static String getHostName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }

    public static String getDomainName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "";
        }
    }

    public static String getAccessToken() {
        try {
            CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(accessTokenUrl);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
            arrayList.add(new BasicNameValuePair("grant_type", "client_credentials"));
            arrayList.add(new BasicNameValuePair("client_id", clientId));
            arrayList.add(new BasicNameValuePair("client_secret", clientSecret));
            httpPost.setEntity(new UrlEncodedFormEntity(arrayList, "UTF-8"));
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute(httpPost);
            Gson gson = new Gson();
            String string = EntityUtils.toString(closeableHttpResponse.getEntity());
            AccessTokenInfo accessTokenInfo = (AccessTokenInfo)gson.fromJson(string, AccessTokenInfo.class);
            closeableHttpResponse.close();
            closeableHttpClient.close();
            return accessTokenInfo.getAccessToken();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static final String getProcessID() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return runtimeMXBean.getName().split("@")[0];
    }

    public static void main(String[] stringArray) {
        try {
            LdkRuntimeRestAPI ldkRuntimeRestAPI;
            Sample.loadProperties();
            Logger logger = Logger.getLogger("java_ws_sample");
            if (authType.equals("identity")) {
                ldkRuntimeRestAPI = new LdkRuntimeRestAPI(vendorId, clientIdentity, endpointScheme, serverAddr, serverPort);
            } else if (authType.equals("accesstoken")) {
                ldkRuntimeRestAPI = new LdkRuntimeRestAPI(vendorId, Sample.getAccessToken(), userId, endpointScheme, serverAddr, serverPort);
            } else {
                logger.log(Level.SEVERE, "Invalid auth type!");
                return;
            }
            logger.log(Level.INFO, "Begin Calling Web service");
            logger.log(Level.INFO, "Start Call Login");
            LicenseRequest licenseRequest = new LicenseRequest();
            licenseRequest.setFeatureId(Integer.parseInt(featureId));
            licenseRequest.setFullInfo(fullInfo);
            ClientInfo clientInfo = new ClientInfo();
            clientInfo.setDomainName(Sample.getDomainName());
            clientInfo.setHostName(Sample.getHostName());
            clientInfo.setUserName(userName);
            clientInfo.setMachineId(Sample.getHostName());
            clientInfo.setProcessId(Sample.getProcessID());
            clientInfo.setClientDateTime(ldkRuntimeRestAPI.getCurrentDate());
            licenseRequest.setClientInfo(clientInfo);
            Scope scope = new Scope();
            ArrayList<String> arrayList = null;
            if (keyId != null && !keyId.isEmpty()) {
                arrayList = new ArrayList<String>();
                arrayList.add(keyId);
                scope.setKeyId(arrayList);
            }
            ArrayList<Integer> arrayList2 = null;
            if (productId != null && !productId.isEmpty()) {
                arrayList2 = new ArrayList<Integer>();
                arrayList2.add(Integer.parseInt(productId));
                scope.setProductId(arrayList2);
            }
            if (arrayList != null || arrayList2 != null) {
                licenseRequest.setScope(scope);
            }
            LicenseResponse licenseResponse = ldkRuntimeRestAPI.login(licenseRequest);
            String string = "";
            if (licenseResponse != null) {
                logger.log(Level.INFO, "Login result - \n{0}", licenseResponse);
                string = licenseResponse.getSessionId();
            }
            logger.log(Level.INFO, "Start Call getKeyList");
            KeysResponse keysResponse = ldkRuntimeRestAPI.getKeyList(0, 5);
            if (keysResponse != null) {
                logger.log(Level.INFO, "getKeyList result - \n{0}", keysResponse);
            }
            logger.log(Level.INFO, "Start Call getProductList");
            ProductsResponse productsResponse = ldkRuntimeRestAPI.getProudctList(0, 5);
            if (productsResponse != null) {
                logger.log(Level.INFO, "getProductList result - \n{0}", productsResponse);
            }
            logger.log(Level.INFO, "Start Call getFeatureList");
            FeaturesResponse featuresResponse = ldkRuntimeRestAPI.getFeatureList(0, 5);
            if (featuresResponse != null) {
                logger.log(Level.INFO, "getFeatureList result - \n{0}", featuresResponse);
            }
            logger.log(Level.INFO, "Start Call getMemoryList");
            MemoriesResponse memoriesResponse = ldkRuntimeRestAPI.getMemoryList(0, 5);
            if (memoriesResponse != null) {
                logger.log(Level.INFO, "getMemoryList result - \n{0}", memoriesResponse);
            }
            if (!string.isEmpty()) {
                logger.log(Level.INFO, "Start Call Refresh Session");
                LicenseResponse licenseResponse2 = ldkRuntimeRestAPI.refreshSession();
                if (licenseResponse2 != null) {
                    logger.log(Level.INFO, "Refresh Session result - \n{0}", licenseResponse2);
                }
                logger.log(Level.INFO, "Start Call Read Memory");
                ReadMemoryResponse readMemoryResponse = ldkRuntimeRestAPI.readMemory(Integer.parseInt(memoryId), Integer.parseInt(offset), Integer.parseInt(length));
                if (readMemoryResponse != null) {
                    logger.log(Level.INFO, "Read Memory result - \n{0}", readMemoryResponse);
                }
                logger.log(Level.INFO, "Start Call Logout");
                LogoutResponse logoutResponse = ldkRuntimeRestAPI.logout();
                logger.log(Level.INFO, "Logout result - \n{0}", logoutResponse);
            }
            logger.log(Level.INFO, "End Calling Web service");
        }
        catch (Exception exception) {
            Logger logger = Logger.getLogger("java_ws_sample");
            logger.log(Level.INFO, exception.getMessage());
        }
    }
}

