/*
 * Decompiled with CFR 0.152.
 */
package com.sfnt.ldk.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

public class ServiceUtil {
    private static final Log log = LogFactory.getLog(ServiceUtil.class);
    private static final String HEADER_ORIGIN = "Origin";
    private static final String ORIGIN_VALUE = "http://127.0.0.1";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_TYPE_VALUE = "application/json";
    private static final String HEADER_ACCEPT = "Accept";
    private static final String DEFAULT_JSON_CONTENT_TYPE = "application/json";

    private ServiceUtil() {
        throw new IllegalStateException("ServiceUtil class");
    }

    public static CloseableHttpClient createHttpClient(String string) {
        CloseableHttpClient closeableHttpClient = null;
        if (string.indexOf("https") != -1) {
            try {
                closeableHttpClient = HttpClients.custom().setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                    @Override
                    public boolean isTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                        return true;
                    }
                }).build()).build();
            }
            catch (Exception exception) {
                log.error((Object)"Exception in creating http client instance", (Throwable)exception);
            }
        } else {
            closeableHttpClient = HttpClients.createDefault();
        }
        return closeableHttpClient;
    }

    public static HttpGet createHttpGet(int n, String string, Map<String, String> map) {
        Object object;
        HttpGet httpGet = new HttpGet(string);
        httpGet.setHeader(HEADER_ORIGIN, ORIGIN_VALUE);
        httpGet.setHeader(HEADER_ACCEPT, "application/json");
        httpGet.setHeader(HEADER_CONTENT_TYPE, "application/json");
        if (!map.isEmpty()) {
            object = map.keySet();
            Iterator<String> iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                httpGet.setHeader(string2, map.get(string2));
            }
        }
        object = RequestConfig.custom().setConnectTimeout(n).setConnectionRequestTimeout(n).setSocketTimeout(n).build();
        httpGet.setConfig((RequestConfig)object);
        return httpGet;
    }

    public static HttpPatch createHttpPatch(int n, String string, String string2, Map<String, String> map) {
        Object object;
        Object object2;
        HttpPatch httpPatch = new HttpPatch(string);
        httpPatch.setHeader(HEADER_ORIGIN, ORIGIN_VALUE);
        httpPatch.setHeader(HEADER_ACCEPT, "application/json");
        httpPatch.setHeader(HEADER_CONTENT_TYPE, "application/json");
        if (!map.isEmpty()) {
            object2 = map.keySet();
            object = object2.iterator();
            while (object.hasNext()) {
                String string3 = object.next();
                httpPatch.setHeader(string3, map.get(string3));
            }
        }
        object2 = new StringEntity(string2, StandardCharsets.UTF_8);
        object = RequestConfig.custom().setConnectTimeout(n).setConnectionRequestTimeout(n).setSocketTimeout(n).build();
        httpPatch.setConfig((RequestConfig)object);
        httpPatch.setEntity((HttpEntity)object2);
        return httpPatch;
    }

    public static HttpDelete createHttpDelete(int n, String string, Map<String, String> map) {
        Object object;
        HttpDelete httpDelete = new HttpDelete(string);
        httpDelete.setHeader(HEADER_ORIGIN, ORIGIN_VALUE);
        httpDelete.setHeader(HEADER_ACCEPT, "application/json");
        httpDelete.setHeader(HEADER_CONTENT_TYPE, "application/json");
        if (!map.isEmpty()) {
            object = map.keySet();
            Iterator<String> iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                httpDelete.setHeader(string2, map.get(string2));
            }
        }
        object = RequestConfig.custom().setConnectTimeout(n).setConnectionRequestTimeout(n).setSocketTimeout(n).build();
        httpDelete.setConfig((RequestConfig)object);
        return httpDelete;
    }

    public static HttpPost createHttpPost(int n, String string, String string2, Map<String, String> map) {
        Object object;
        Object object2;
        HttpPost httpPost = new HttpPost(string);
        httpPost.setHeader(HEADER_ORIGIN, ORIGIN_VALUE);
        httpPost.setHeader(HEADER_ACCEPT, "application/json");
        httpPost.setHeader(HEADER_CONTENT_TYPE, "application/json");
        if (!map.isEmpty()) {
            object2 = map.keySet();
            object = object2.iterator();
            while (object.hasNext()) {
                String string3 = object.next();
                httpPost.setHeader(string3, map.get(string3));
            }
        }
        object2 = new StringEntity(string2, StandardCharsets.UTF_8);
        object = RequestConfig.custom().setConnectTimeout(n).setConnectionRequestTimeout(n).setSocketTimeout(n).build();
        httpPost.setConfig((RequestConfig)object);
        httpPost.setEntity((HttpEntity)object2);
        return httpPost;
    }

    public static void closeHttpClient(CloseableHttpClient closeableHttpClient, CloseableHttpResponse closeableHttpResponse) {
        if (closeableHttpResponse != null) {
            try {
                closeableHttpResponse.close();
            }
            catch (IOException iOException) {
                log.error((Object)"Error while closing response : ", (Throwable)iOException);
            }
        }
        if (closeableHttpClient != null) {
            try {
                closeableHttpClient.close();
            }
            catch (IOException iOException) {
                log.error((Object)"Error while closing httpClient : ", (Throwable)iOException);
            }
        }
    }

    public static InputStream getInputStream(String string) {
        return ServiceUtil.class.getClassLoader().getResourceAsStream(string);
    }

    public static String getDataFromResponse(HttpResponse httpResponse) throws Exception {
        String string = EntityUtils.toString(httpResponse.getEntity());
        EntityUtils.consume(httpResponse.getEntity());
        return string;
    }
}

