window.overview = (function () {/*
<div class="overview-div"><h1>Sentinel LDK Licensing REST API Reference</h1><p>This is the reference documentation for the Sentinel LDK Licensing REST API. It is intended for developers who want to integrate licensing functionalities, such as license and entitlement management, in their applications.</p><p></p>The Sentinel LDK Licensing REST API is recommended for use with both cloud-based applications (Software-as-a-Service (SaaS) offerings) and local applications that run in a trusted environment. There is no need to embed or install Sentinel LDK Run-time Environment or License Manager. If your application runs locally in an untrusted environment, we recommend using <a href="https://docs.sentinel.thalesgroup.com/ldk/vendor-tools.htm" target="_blank">Sentinel LDK Envelope</a>, which wraps your application in a protective shield. The Sentinel LDK Licensing REST API is especially recommended for server-side web applications, where the API is called on behalf of the application.</p>
<p>The API Reference describes the following:</p>
<ul class="ul-level1"><li>Available endpoints and <a href="#methods">HTTP methods</a> on each endpoint</li><li>Input and output for each operation</li><li>JSON model</li><li><a href="#codes">Status codes</a></li><li><a href="#types">Types of authentication methods</a></li><li><a href="#userAuthn">OAuth 2.0-based authentication</a></li><li><a href="#signature">Identity string-based authentication</a></li></ul>
<table class="note">
  <tr>
    <td>
      <a target="_blank" class="fa fa-sticky-note-o"></a>
    </td>
    <td><p>The Sentinel LDK Licensing REST API supports both HTTP and HTTPS. 
<ul class="ul-level2"><li>If you are working with Sentinel EMS, which is managed and hosted by Thales, you must use HTTPS. Thales handles the web server certificate for you.</li>
<li>If you are hosting the application portal yourself, you can use either HTTP or HTTPS, although HTTPS is recommended. When using HTTPS, make sure to install an SSL/TLS certificate on your web server and to configure your server accordingly. Also, make sure that all internal links and resources on your website are using HTTPS to avoid mixed content warnings.</li>  
    </td> 
  </tr>
</table>

<h2>Before you begin</h2><p>If you are new to the Sentinel LDK licensing, read through the <a target="_blank" href="https://docs.sentinel.thalesgroup.com/ldk/LDKdocs/SPNL/LDK_SLnP_Guide/Familiarizing/About_Guide.htm">Sentinel LDK Software Protection and Licensing Guide</a> to learn more about cloud and on-premises licensing.<p><p>If you are already familiar with the Sentinel LDK Licensing REST API user interface workflows, and just need to refer to the API documentation, you are in the right place.</p>
<p>The API Reference layout consists of the following:</p><ul class="ul-level1"><li><b>Navigation section</b>: The navigation section (the pane on the left) lists all available resources and operations that can be performed on them.</li><li><b>Content section</b>: The content section of the API Reference is further divided into the following:<ul class="ul-level2"><li><b>Description section</b>: The description section provides endpoint details, such as HTTP Method and URI. It also contains the Lock icon, which is used to set the authorization information to request headers.</li><li><b>Request pane</b>: The left pane lists the available request parameters and the request content type.</li><li><b>Response pane</b>. The right pane displays the response, including status codes, error codes, and sample CURL request.</li></ul></li></ul>
<h2 id="methods">HTTP Methods</h2><p>The following HTTP methods are used for interacting with resources.</p>
<table class="table">
  <tr>
    <th>HTTP Method</th>
    <th>Description</th>
  </tr>
  <tr>
    <td><b>POST</b></td>
    <td><p>A POST request is used to create a new resource. This request is also used to perform operations for which none of the other HTTP methods seems appropriate.</p><p>If the POST request results in the creation of a resource, the response includes a Location header with the address of the new resource.</p></td>
  </tr>
  <tr>
    <td><b>GET</b></td>
    <td><p>A GET request is used to retrieve data. This request does not perform any update on the server.</p><p>Use the GET method to do the following:</p><ul class="ul-level2"><li>Retrieve details of a resource.</li><li>Search resources based on given query parameters.</li></ul></p><p>The GET method supports the embed query parameter, which helps in dynamically selecting the output.</p></td>
  </tr>
  <tr>
    <td><b>PUT</b></td>
    <td><p>A PUT request is used to replace a resource. Use the PUT method to update a resource (available at the given URI) with another resource. Consider the following when using the PUT method in the request body:</p><ul class="ul-level2"><li>If a parameter is not provided, the existing database value for that parameter will be replaced by blank or default. This is the main difference between PUT and PATCH. In PUT, the parameter will be replaced by blank or default, whereas in PATCH, the parameter will remain unchanged.</li><li>If a parameter is set to blank, the database value will be updated with a blank entry.</li><li>If a parameter is set to a valid value, the database value will be updated with the given value.</li></ul><p>Do not use PUT to remove associations.</p><ul class="ul-level2"><li>If an association list is provided in the input, the existing list will be replaced by the provided list.</li><li>If a blank association list is provided, no action will be taken.</li></td>
  </tr>
  <tr>
    <td><b>PATCH</b></td>
    <td><p>A PATCH request is used for partial updates to an existing resource. In this case, all the values that are part of the request are updated. Consider the following when using the PATCH method in the request body:</p><ul class="ul-level2"><li>If a parameter is not provided, the existing database value for that parameter will remain unchanged. This is the main difference between PUT and PATCH. In PUT, the parameter will be replaced by blank or default, whereas in PATCH, the parameter will remain unchanged.</li><li>If a parameter is set to blank, the database value will be updated with a blank entry.</li><li>If a parameter is set to a valid value, the database value will be updated with the given value.</li></ul><p>Do not use PATCH to remove associations.</p><ul class="ul-level2"><li>If an association list is provided in the input, the existing list will be replaced by the provided list.</li><li>If a blank association list is provided, no action will be taken.</li></td>
  </tr>
  <tr>
    <td><b>DELETE</b></td>
    <td><p>A DELETE request is used to remove a resource. You can use the DELETE method to delete an entity or to remove one or more associations from an entity.</p></td>
  </tr>
  </table>
  <h3>The returnResource Parameter</h3><p>POST, PUT, and PATCH requests support an optional request parameter, returnResource, which has the Boolean data type. This parameter controls whether or not to return a created/updated resource in the response body.</p>
<h2 id="codes">Status Codes</h2><p>Below is a list of possible status codes that may be returned when using the Sentinel Licensing REST API.</p><table class="table">
  <tr>
    <th>Status Code</th>
    <th>Description</th>
  </tr>
  <tr>
    <td>200 OK</td>
    <td>Indicates non-specific success, for example, the request was successfully completed. Do not use to communicate errors in the response body.</td>
  </tr>
  <tr>
    <td>201 Created</td>
    <td>Indicates successful resource creation.</td>
  </tr>
    <tr>
    <td>202 Accepted</td>
    <td>Indicates successful start of an asynchronous action.</td>
  </tr>
    <tr>
    <td>204 No Content</td>
    <td>Indicates that the response body is intentionally empty.</td>
  </tr>
    <tr>
    <td>400 Bad Request</td>
    <td>Indicates a non-specific failure.</td>
  </tr>
    <tr>
    <td>401 Unauthorized</td>
    <td>Indicates a problem with the client&#39s credentials.</td>
  </tr>
    <tr>
    <td>403 Forbidden</td>
    <td>Indicates no permission to access this resource.</td>
  </tr>
    <tr>
    <td>404 Not Found</td>
    <td>Used when a client&#39s URI cannot be mapped to a resource.</td>
  </tr>
    <tr>
    <td>405 Method Not Allowed</td>
    <td>Used when the HTTP method is not supported.</td>
  </tr>
    <tr>
    <td>409 Conflict</td>
    <td>Indicates a request conflict with the current state of the target resource.</td>
  </tr>
    <tr>
    <td>422 Unprocessable Entity</td>
    <td>Indicates that the server cannot process the request. Returns the error code in the response body. For a list of possible error codes, see <a href='https://docs.sentinel.thalesgroup.com/ldk/LDKdocs/API-licensing/Licensing_API/Enumerations/Licensing_API_Status_Codes.htm' target='_blank'>Sentinel Licensing API Status Codes</a>.</td>
  </tr>
    <tr>
    <td>429 Too Many Requests</td>
    <td>Indicates that incoming traffic exceeds the threshold. A Retry-After response header will be included to indicate how many seconds to wait before making a new request.</td>
  </tr>
    <tr>
    <td>500 Internal Server Error</td>
    <td>Indicates an API malfunction.</td>
  </tr>
  <tr>
    <td>503 Service Unavailable</td>
    <td>Indicates that the server is unable to handle the request due to a temporary overload or maintenance of the server.</td>
  </tr>
</table>
<h2 id="types">Types of Authentication Methods</h2>
<p>Using this REST API, you can apply either <a href="#userAuthn">OAuth-based</a> or <a href="#signature">identity string-based</a> authentication.</p>
<h2 id="userAuthn">OAuth 2.0-Based Authentication (User-Based Licensing)</h2>
<p>Use with user-based licensing, which uses login credentials. You provide login credentials to end users, which they can then use to run your protected applications or services on any supported device. This is recommended for server-side web applications and services, where the API is called on behalf of the application or service.</p>
<p><b>Prerequisites:</b> Before using this REST API, you must create the required users and OAuth clients in Sentinel EMS. After you create users, you must associate the products used in your application or service with the relevant Sentinel EMS users.</p><p>For details on creating users in Sentinel EMS, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/LDK-UG/Default.htm#cshid=1142' target='_blank'>Users</a>.</p><p>For a general introduction to OAuth clients when using the Sentinel REST APIs, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/LDK-UG/Default.htm#cshid=1027' target='_blank'>OAuth Clients</a>.</p><p>For an overview of the various OAuth workflows that you can use when defining OAuth clients in Sentinel EMS and when using OAuth with the Sentinel REST APIs, including the Sentinel LDK Licensing REST API and Sentinel EMS REST API, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/UG/Default.htm#cshid=1028' target='_blank'>Sentinel EMS Workflow with OAuth Clients</a>.</p><p>For details on associating products with users in Sentinel EMS, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/LDK-UG/Default.htm#cshid=1025' target='_blank'>Product-to-User Association</a>.</p>
<h3 id="public-conf-clients">Public and Confidential Clients</h3>
<p>When using OAuth-based authentication for both public and confidential clients, you must set the Authorization header for each request as follows:</p>
<p><code>Authorization: Bearer &lt;JWT_Token&gt;</code></p>
<p>For example:</p>
<p><code>Authorization: Bearer eyJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6IC98cd...</code></p>
<p><i>where</i></p>
<ul class="ul-level2"><li>Bearer indicates that the client is presenting a JWT (JSON Web Token) bearer token for authentication purposes.</li><li>&lt;JWT_Token&gt; is the actual JWT used as the bearer token. In this example, &lt;JWT_Token&gt; is eyJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6IC98cd... <br>The JWT access token is returned by the Sentinel IDP identity provider after successful authentication using the login credentials of an OAuth client.</li></ul>
<h3 id="conf-clients">Confidential Clients</h3>
<p>Confidential clients are used when your application's backend service uses confidential credentials. If you are using a confidential client, you must include an additional request header, <code>X-LDK-User-Id</code>.</p><p>This custom header contains the Sentinel EMS user ID, which identifies the user that is associated with the specific product. Before calling the Sentinel LDK Licensing REST API, the application must log into the Sentinel IDP identity provider using the confidential client to get the confidential client’s access token. You then pass this access token as a bearer token in the HTTP Authorization request header as described in <a href="#public-conf-clients">Public and Confidential Clients</a>. You must also pass the Sentinel EMS user ID with the HTTP <code>X-LDK-User-Id</code> request header as follows:</p> 
<p><code>X-LDK-User-Id: &lt;user ID&gt;</code></p>
For example:</p>
<p><code>X-LDK-User-Id: Charlie_Brown</code></p>
<p><i>where</i></p>
<ul class="ul-level2"><li>&lt;user ID&gt; is the <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/LDK-UG/Default.htm#cshid=1087' target='_blank'>User ID</a> defined in Sentinel EMS. In this example, &lt;user ID&gt; is Charlie_Brown.</li></ul>
<h3 id="additional-header">Additional Request Header</h3>
<p>Every request must also use the <code>X-LDK-Instance</code> header to enable a sticky session and improve API performance.</p>
<p><code>X-LDK-Instance: Identity=&lt;identity_code or user_id or guid&gt;</code></p>
For example:</p>
<p><code>X-LDK-Instance: KZMSEU3</code></p>
<p><code>X-LDK-Instance: Charlie_Brown</code></p>
<p><code>X-LDK-Instance: xxxx-xxxx-xxxx-xxxx</code></p>
<p><i>where</i></p>
<ul class="ul-level2">
<li>&lt;Identity_Code&gt; is KZMSEU3.</li>
<li>&lt;User-Id&gt; is Charlie_Brown.</li>
<li>&lt;GUID&gt; is xxxx-xxxx-xxxx-xxxx.</li></ul>
<h2 id="signature">Identity String-Based Authentication</h2>
<p>Client identities are installed directly on the machine or device, eliminating the need for user authentication. Anyone that can access the device can use the application or service without logging on to the application using traditional login credentials, such as a user name and password. </p>
<p>When using Sentinel EMS, you set up <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/LDK-UG/Default.htm#cshid=1117' target='_blank'>machine accounts</a> to handle identity string-based authentication.</p>
<p>When using identity string-based authentication, you must apply a web service signature using the <code>X-LDK-Identity-WS</code> header for each request, for example:</p>
<p><code>X-LDK-Identity-WS: V1, Identity=KZMSEU3, RequestDate=2023-08-30T12:36:00Z, Signature=98cd2651598ac9460e8a336912d8bf683c4690d6043ca8a51680143cde080f3c</code></p>
<p><i>where</i></p>
<ul class="ul-level2"><li>V1 is a fixed string defining the version.</li><li>Identity defines the identity code.</li><li>RequestDate is formatted as YYYY-MM-DDTHH:MM:SSZ  (20 characters).</li></ul>
<p>The signature is computed as follows:</p><ul class="ul-level2"><li>IdentitySecret = 16 bytes secret from the identity</li><li>DerivedKey = HMAC-SHA256(IdentitySecret, "X-LDK-Identity-WS-V1") (32 bytes)</li><li>Signature = HMAC-SHA256 (DerivedKey, Identity + RequestDate + Url + "^" + Body) (32 bytes)</li></ul><p><i>where</i></p><ul class="ul-level2"><li>Identity and RequestDate are the exact bytes that are passed in the X-LDK-Identity-WS header.</li><li>Url example: "/sentinel/ldk_runtime/v1/vendors/37515/keys"
</li><li>"^" ensures that Url and Body are clearly separated. Both Url and Body are invalidated if the cutoff is moved.</li></ul>
<h3 id="additional-header">Additional Request Header</h3>
<p>Every request must also use the <code>X-LDK-Instance</code> header to enable a sticky session and improve API performance.</p>
<p><code>X-LDK-Instance: Identity=&lt;identity_code or user_id or guid&gt;</code></p>
For example:</p>
<p><code>X-LDK-Instance: KZMSEU3</code></p>
<p><code>X-LDK-Instance: Charlie_Brown</code></p>
<p><code>X-LDK-Instance: xxxx-xxxx-xxxx-xxxx</code></p>
<p><i>where</i></p>
<ul class="ul-level2">
<li>&lt;Identity_Code&gt; is KZMSEU3.</li>
<li>&lt;User-Id&gt; is Charlie_Brown.</li>
<li>&lt;GUID&gt; is xxxx-xxxx-xxxx-xxxx.</li></ul>
</div>
*/}).toString().match(/[^]*\/\*([^]*)\*\/\}$/)[1];