LicensingSpec = // DO NOT REMOVE THIS LINE
// UPDATE THE LATEST JSON BELOW
{
  "openapi": "3.0.1",
  "servers": [
    {
      "url": "https://localhost:1947"
    },
    {
      "url": "http://localhost:1947"
    }
  ],
  "tags": [
    {
      "name": "features",
      "icon": "fas fa-tags",
      "displayName": "Features"
    },
    {
      "name": "keys",
      "icon": "fas fa-key",
      "displayName": "Keys"
    },
    {
      "name": "memories",
      "icon": "fas fa-tags",
      "displayName": "Memory Files"
    },
    {
      "name": "products",
      "icon": "fas fa-tags",
      "displayName": "Products"
    },
    {
      "name": "sessions",
      "icon": "fas fa-chart-bar",
      "displayName": "Sessions"
    }
  ],
  "paths": {
    "/sentinel/ldk_runtime/v1/vendors/{vendorId}/features": {
      "get": {
        "tags": [
          "features"
        ],
        "summary": "Get Feature List",
        "description": "Retrieve a list of all features for the specified vendor. \nFor details on which header(s) to use, see <a href='index.html?info#types' target='_blank'>Types of authentication methods</a>.",
        "operationId": "Get Feature List",
        "parameters": [
          {
            "name": "Authorization",
            "in": "header",
            "description": "<i>Format</i>: Authorization: Bearer &lt;JWT_Token&gt;\n\n<i>Example</i>: Authorization: Bearer eyJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6IC98cd... \n\nUse this header for user-based licensing, which uses login credentials.\n\nThe Sentinel LDK REST API uses the standard HTTP Authorization header to pass the JWT access token. The JWT access token is returned by the Sentinel IDP identity provider after successful authentication using the login credentials of an OAuth client. You create the OAuth client in Sentinel EMS. \n\nFor more details, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/UG/clients.htm#Creating' target='_blank'>Adding an OAuth Client</a>.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-User-Id",
            "in": "header",
            "description": "<i>Format</i>: X-LDK-User-Id: &lt;OAuth client name&gt;\n\n<i>Example</i>: X-LDK-User-Id: Charlie_Brown \n\nIf you are using user-based licensing with a confidential OAuth client, you must add this additional header.\n\nThis custom header contains the name that identifies the user. Before calling the Sentinel LDK Licensing REST API, the application must log into the Sentinel IDP identity provider using the confidential client. \n\nFor more details, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/UG/clients.htm' target='_blank'>OAuth Clients</a>.\n",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-Identity-WS",
            "in": "header",
            "description": "<i>Format</i>: X-LDK-Identity-WS &lt;version&gt;,Identity=&lt;identity_code&gt;,RequestDate=&lt;YYYY-MM-DDTHH:MM:SSZ&gt;,Signature=&lt;web_service_signature&gt; \n\n<i>Example</i>: X-LDK-Identity-WS: V1, Identity=KZMSEU3, RequestDate=2023-08-30T12:36:00Z, Signature=98cd2651598ac9460e8a336912d8bf683c4690d6043ca8a51680143cde080f3c \n\nUse this header for identity string-based licensing, which uses the identity string that is installed on the end user's machine.\n\nFor details on verifying a web service signature, see <a href='index.html?info#signature' target='_blank'>Client Identity-Based Authentication</a>.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-Instance",
            "in": "header",
            "description": "<i>Format</i>:X-LDK-Instance:Identity=&lt;identity_code or user_id or guid&gt;         \n<i>Examples</i>: \nX-LDK-Instance: Identity_Code=KZMSEU3 \nX-LDK-Instance: User-Id=Charlie_Brown \nX-LDK-Instance: GUID=xxxx-xxxx-xxxx-xxxx\n\nUse this header in every request to enable a sticky session to improve the API performance.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "pageStartIndex",
            "in": "query",
            "description": "Starting index of the returned records.",
            "schema": {
              "type": "integer",
              "format": "int32",
              "default": 0
            }
          },
          {
            "name": "pageSize",
            "in": "query",
            "description": "Number of records to return per page.",
            "schema": {
              "type": "integer",
              "format": "int32",
              "default": 10
            }
          },
          {
            "name": "vendorId",
            "in": "path",
            "description": "Unique ID of the software vendor.",
            "required": true,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "OK",
            "content": {
              "application/json": {
                "schema": {
                  "type": "object",
                  "properties": {
                    "features": {
                      "type": "object",
                      "properties": {
                        "count": {
                          "description": "Total number of records.",
                          "type": "integer",
                          "example": 1
                        },
                        "feature": {
                          "type": "array",
                          "items": {
                            "type": "object",
                            "properties": {
                              "concurrency": {
                                "type": "object",
                                "properties": {
                                  "count": {
                                    "type": "string",
                                    "description": "How concurrency instances are to be counted. \n Possible values: \n - login \n - station \n - process",
                                    "example": "login"
                                  },
                                  "export": {
                                    "type": "string",
                                    "description": "Comma-separated list of flags that describes the concurrency. \n Possible values: \n - network \n - display \n - local",
                                    "example": "display"
                                  },
                                  "seats": {
                                    "type": "integer",
                                    "description": "Total number of available instances for concurrency.",
                                    "format": "int32",
                                    "example": 100
                                  }
                                }
                              },
                              "detachable": {
                                "type": "boolean",
                                "description": "Whether the Feature can be detached from a Sentinel SL key.\n Possible values: \n - true \n - false",
                                "example": "true"
                              },
                              "disabled": {
                                "type": "boolean",
                                "description": "Whether the Feature is disabled because the running machine does not satisfy a license requirement.\n Note: A Feature may not be usable even it returns false for the disabled tag. To determine if a Feature is usable, check the return value for the usable tag. \n Possible values: \n - true \n - false",
                                "example": false
                              },
                              "expired": {
                                "type": "boolean",
                                "description": "Whether the Feature on the Sentinel protection key has expired.\n Possible values: \n - true \n - false",
                                "example": true
                              },
                              "featureId": {
                                "type": "integer",
                                "description": "User-defined unique identifier for a specific Feature stored in a Sentinel protection key. This number is passed to the Create Session endpoint to establish access to the Feature.",
                                "format": "int32",
                                "example": 123456
                              },
                              "productId": {
                                "type": "integer",
                                "description": "Unique identifier for the Product associated with the Feature.",
                                "format": "int32",
                                "example": 12345
                              },
                              "keyId": {
                                "type": "integer",
                                "description": "Key ID of the Sentinel protection key.",
                                "format": "int64",
                                "example": 591751327
                              },
                              "licenseInfo": {
                                "type": "object",
                                "properties": {
                                  "totalCounter": {
                                    "type": "integer",
                                    "description": "Total pool of executions. Used in conjunction with the 'executions' license type.",
                                    "format": "int32"
                                  },
                                  "currentCounter": {
                                    "type": "integer",
                                    "description": "Number of used executions. Used in conjunction with the 'executions' license type.",
                                    "format": "int32"
                                  },
                                  "expirationDateTime": {
                                    "type": "string",
                                    "description": "Expiration date and time of an expiration-based license. Used in conjunction with the 'expiration' license type. Format:YYYY-MM-DDTHH:MM:SSZ",
                                    "format": "date-time",
                                    "example": "2033-07-01T23:59:59.000Z"
                                  },
                                  "startDateTime": {
                                    "type": "string",
                                    "description": "Start date and time of an expiration-based license or trial license. Used in conjunction with the 'expiration' or 'trial' license type.",
                                    "format": "date-time",
                                    "example": "2023-07-01T23:59:59.000Z"
                                  },
                                  "totalDuration": {
                                    "type": "integer",
                                    "description": "Total amount of time (in seconds) for which a trial license is valid. Used in conjunction with the 'trial' license type.",
                                    "format": "int32"
                                  },
                                  "type": {
                                    "type": "string",
                                    "description": "Type of license. \n Possible values: \n - perpetual \n - executions \n - expiration \n - trial ('trial' represents any time period-based license)",
                                    "example": "perpetual"
                                  }
                                }
                              },
                              "locked": {
                                "type": "boolean",
                                "description": "Whether the Feature is locked to the Sentinel protection key. This means that the feature will be disabled if the Sentinel SL key is disabled. \n Possible values: \n - true (Returns true for a Sentinel HL key) \n - false"
                              },
                              "name": {
                                "type": "string",
                                "description": "The Feature name, or an empty string if the Features name is unavailable.",
                                "example": "Multiply"
                              },
                              "usable": {
                                "type": "boolean",
                                "description": "Whether the Feature can be used. A Feature is not usable if it is disabled or expired. \n Possible values: \n - true \n - false"
                              },
                              "vmEnabled": {
                                "type": "boolean",
                                "description": "Whether the Feature can be hosted by a virtual machine. \n Possible values: \n - true \n - false"
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          },
          "401": {
            "description": "Unauthorized"
          },
          "403": {
            "description": "Forbidden"
          },
          "404": {
            "description": "Not Found"
          },
          "422": {
            "description": "Unprocessable Entity. For a list of possible error codes, see <a href='https://docs.sentinel.thalesgroup.com/ldk/LDKdocs/API-licensing/Licensing_API/Enumerations/Licensing_API_Status_Codes.htm' target='_blank'>Sentinel Licensing API Status Codes</a>.\nFor a list of HTTP status code descriptions, see <a href='index.html?info#codes' target='_blank'>HTTP Status Codes</a>.",
            "content": {
              "application/json": {
                "schema": {
                  "type": "object",
                  "properties": {
                    "errorCode": {
                      "type": "integer",
                      "description": "Sentinel Licensing API status codes",
                      "format": "int32",
                      "example": 36
                    },
                    "message": {
                      "type": "string",
                      "description": "Brief description of Sentinel Licensing API Status Codes. For details, see <a href='index.html?info#codes' target='_blank'>HTTP Status Codes</a> and <a href='https://docs.sentinel.thalesgroup.com/ldk/LDKdocs/API-licensing/Licensing_API/Enumerations/Licensing_API_Status_Codes.htm' target='_blank'>Sentinel Licensing API Status Codes</a>.",
                      "example": "HASP_INV_SCOPE"
                    }
                  }
                }
              }
            }
          },
          "429": {
            "description": "Too Many Requests"
          }
        },
        "deprecated": false
      }
    },
    "/sentinel/ldk_runtime/v1/vendors/{vendorId}/keys": {
      "get": {
        "tags": [
          "keys"
        ],
        "summary": "Get Key List",
        "description": "Retrieve a list of all keys for the specified vendor. \nFor details on which header(s) to use, see <a href='index.html?info#types' target='_blank'>Types of authentication methods</a>.",
        "operationId": "Get Key List",
        "parameters": [
          {
            "name": "Authorization",
            "in": "header",
            "description": "<i>Format</i>: Authorization: Bearer &lt;JWT_Token&gt;\n\n<i>Example</i>: Authorization: Bearer eyJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6IC98cd... \n\nUse this header for user-based licensing, which uses login credentials.\n\nThe Sentinel LDK REST API uses the standard HTTP Authorization header to pass the JWT access token. The JWT access token is returned by the Sentinel IDP identity provider after successful authentication using the login credentials of an OAuth client. You create the OAuth client in Sentinel EMS. \n\nFor more details, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/UG/clients.htm#Creating' target='_blank'>Adding an OAuth Client</a>.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-User-Id",
            "in": "header",
            "description": "<i>Format</i>: X-LDK-User-Id: &lt;OAuth client name&gt;\n\n<i>Example</i>: X-LDK-User-Id: Charlie_Brown \n\nIf you are using user-based licensing with a confidential OAuth client, you must add this additional header.\n\nThis custom header contains the name that identifies the user. Before calling the Sentinel LDK Licensing REST API, the application must log into the Sentinel IDP identity provider using the confidential client. \n\nFor more details, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/UG/clients.htm' target='_blank'>OAuth Clients</a>.\n",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-Identity-WS",
            "in": "header",
            "description": "<i>Format</i>: X-LDK-Identity-WS &lt;version&gt;,Identity=&lt;identity_code&gt;,RequestDate=&lt;YYYY-MM-DDTHH:MM:SSZ&gt;,Signature=&lt;web_service_signature&gt; \n\n<i>Example</i>: X-LDK-Identity-WS: V1, Identity=KZMSEU3, RequestDate=2023-08-30T12:36:00Z, Signature=98cd2651598ac9460e8a336912d8bf683c4690d6043ca8a51680143cde080f3c \n\nUse this header for identity string-based licensing, which uses the identity string that is installed on the end user's machine.\n\nFor details on verifying a web service signature, see <a href='index.html?info#signature' target='_blank'>Client Identity-Based Authentication</a>.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-Instance",
            "in": "header",
            "description": "<i>Format</i>:X-LDK-Instance:Identity=&lt;identity_code or user_id or guid&gt;         \n<i>Examples</i>: \nX-LDK-Instance: Identity_Code=KZMSEU3 \nX-LDK-Instance: User-Id=Charlie_Brown \nX-LDK-Instance: GUID=xxxx-xxxx-xxxx-xxxx\n\nUse this header in every request to enable a sticky session to improve the API performance.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "pageStartIndex",
            "in": "query",
            "description": "Starting index of the returned records.",
            "schema": {
              "type": "integer",
              "format": "int32",
              "default": 0
            }
          },
          {
            "name": "pageSize",
            "in": "query",
            "description": "Number of records to return per page.",
            "schema": {
              "type": "integer",
              "format": "int32",
              "default": 10
            }
          },
          {
            "name": "vendorId",
            "in": "path",
            "description": "Unique ID of the software vendor.",
            "required": true,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "OK",
            "content": {
              "application/json": {
                "schema": {
                  "type": "object",
                  "properties": {
                    "keys": {
                      "type": "object",
                      "properties": {
                        "count": {
                          "description": "Total number of records.",
                          "type": "integer",
                          "example": 1
                        },
                        "key": {
                          "type": "array",
                          "description": "List of available keys.",
                          "items": {
                            "type": "object",
                            "properties": {
                              "attached": {
                                "type": "boolean",
                                "description": "Whether a Sentinel SL key is attached. \n Possible values: \n - true \n - false"
                              },
                              "cloneProtected": {
                                "type": "boolean",
                                "description": "Whether clone protection is enabled. (Relevant only for SL-AdminMode or SL-UserMode) \n Possible values: \n - true \n - false"
                              },
                              "configuration": {
                                "type": "string",
                                "description": "Configuration of the Sentinel protection key. \n Possible values: \n - haspsl-legacy \n - haspsl-adminmode \n - haspsl-usermode \n - hasphl \n - sentinelhl,hasphl \n - hasphl \n - sentinelhl,driverless",
                                "example": "haspsl-adminmode"
                              },
                              "detachable": {
                                "type": "boolean",
                                "description": "Whether the Sentinel SL key supports detachable licenses. \n Possible values: \n - true \n - false"
                              },
                              "disabled": {
                                "type": "boolean",
                                "description": "Whether the protection key contains a license that has been disabled. \n Possible values:  \n - true \n - false"
                              },
                              "driverless": {
                                "type": "boolean",
                                "description": "Whether the protection key is a Sentinel HL (Driverless configuration) key. \n Possible values:  \n - true \n - false"
                              },
                              "fingerprintChanged": {
                                "type": "boolean",
                                "description": "Whether cloning is detected in a product that is locked to a Sentinel SL key. \n Possible values:  \n - true \n - false"
                              },
                              "formFactor": {
                                "type": "string",
                                "description": "The form factor for hardware. (Not relevant for Sentinel SL keys) \n Possible values:  \n - Mini \n - Micro \n - Midi \n - Chip \n - Board",
                                "example": "Mini"
                              },
                              "haspEnabled": {
                                "type": "boolean",
                                "description": "Whether to support Sentinel HL (HASP configuration) keys. \n Possible values: \n - true \n - false"
                              },
                              "hwPlatform": {
                                "type": "string",
                                "description": "The platform of the hardware key. \n Possible values: \n - Sentinel \n - HASP",
                                "example": "Sentinel"
                              },
                              "hwVersion": {
                                "type": "string",
                                "description": "Hardware version of a Sentinel HL key. An empty string is returned for a Sentinel SL key.",
                                "example": 7
                              },
                              "keyId": {
                                "type": "string",
                                "description": "Key ID of the Sentinel protection key.",
                                "example": 591751131
                              },
                              "keyModel": {
                                "type": "string",
                                "description": "Name of the Sentinel protection key model. \n Possible values: \n - Certificate \n - Max \n - MaxMicro \n - MaxChip \n - MaxBoard \n - DriveMicroSD",
                                "example": "Certificate"
                              },
                              "keyType": {
                                "type": "string",
                                "description": "Name of the Sentinel protection key type. \n Possible values: \n - SL-AdminMode \n - Max \n - Time \n - Drive \n - Net10 \n - Net50 \n - Net250+ \n - NetTime10 \n - NetTime50 \n - NetTime250+ \n",
                                "example": "SL-AdminMode"
                              },
                              "productionDateTime": {
                                "type": "string",
                                "description": "For an HL key, this is the date and time (in UTC) when the key was produced. For an HL Time key or HL NetTime key, this is also the date and time when the battery usage started. For an SL AdminMode or SL UserMode key, this is the date and time when the key was deployed on the machine. \n Format: YYYY-MM-DDTHH:MM:SSZ (20 characters)",
                                "format": "date-time",
                                "example": "2023-07-21T17:32:28.000Z"
                              },
                              "recipient": {
                                "type": "boolean",
                                "description": "Whether the license is a detached license. \n Possible values: \n - true \n - false"
                              },
                              "rehost": {
                                "type": "boolean",
                                "description": "Whether the Sentinel protection key can be transferred from one device to another. \n Possible values: \n - true \n - false"
                              },
                              "type": {
                                "type": "string",
                                "description": "Type of Sentinel protection key. \n Possible values: \n - HASP-HL \n - HASP-SL",
                                "example": "HASP-SL"
                              },
                              "updateCounter": {
                                "type": "integer",
                                "description": "Counter that is used to ensure updates can only be applied once and in the correct order.",
                                "format": "int32"
                              },
                              "vClockEnabled": {
                                "type": "boolean",
                                "description": "Whether V-Clock is supported by the protection key. \n Possible values: \n - true \n - false"
                              },
                              "version": {
                                "type": "string",
                                "description": "Sentinel HL key: Firmware version. \n Sentinel SL key: Secure storage version.",
                                "example": 9.12
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          },
          "401": {
            "description": "Unauthorized"
          },
          "403": {
            "description": "Forbidden"
          },
          "404": {
            "description": "Not Found"
          },
          "422": {
            "description": "Unprocessable Entity. For a list of possible error codes, see <a href='https://docs.sentinel.thalesgroup.com/ldk/LDKdocs/API-licensing/Licensing_API/Enumerations/Licensing_API_Status_Codes.htm' target='_blank'>Sentinel Licensing API Status Codes</a>.\nFor a list of HTTP status code descriptions, see <a href='index.html?info#codes' target='_blank'>HTTP Status Codes</a>.",
            "content": {
              "application/json": {
                "schema": {
                  "type": "object",
                  "properties": {
                    "errorCode": {
                      "type": "integer",
                      "description": "Sentinel Licensing API status codes",
                      "format": "int32",
                      "example": 36
                    },
                    "message": {
                      "type": "string",
                      "description": "Brief description of Sentinel Licensing API Status Codes. For details, see <a href='index.html?info#codes' target='_blank'>HTTP Status Codes</a> and <a href='https://docs.sentinel.thalesgroup.com/ldk/LDKdocs/API-licensing/Licensing_API/Enumerations/Licensing_API_Status_Codes.htm' target='_blank'>Sentinel Licensing API Status Codes</a>.",
                      "example": "HASP_INV_SCOPE"
                    }
                  }
                }
              }
            }
          },
          "429": {
            "description": "Too Many Requests"
          }
        },
        "deprecated": false
      }
    },
    "/sentinel/ldk_runtime/v1/vendors/{vendorId}/memories": {
      "get": {
        "tags": [
          "memories"
        ],
        "summary": "Get Memory List",
        "description": "Retrieve a list of all memory files for the specified vendor. \nFor details on which header(s) to use, see <a href='index.html?info#types' target='_blank'>Types of authentication methods</a>.",
        "operationId": "Get Memory List",
        "parameters": [
          {
            "name": "Authorization",
            "in": "header",
            "description": "<i>Format</i>: Authorization: Bearer &lt;JWT_Token&gt;\n\n<i>Example</i>: Authorization: Bearer eyJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6IC98cd... \n\nUse this header for user-based licensing, which uses login credentials.\n\nThe Sentinel LDK REST API uses the standard HTTP Authorization header to pass the JWT access token. The JWT access token is returned by the Sentinel IDP identity provider after successful authentication using the login credentials of an OAuth client. You create the OAuth client in Sentinel EMS. \n\nFor more details, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/UG/clients.htm#Creating' target='_blank'>Adding an OAuth Client</a>.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-User-Id",
            "in": "header",
            "description": "<i>Format</i>: X-LDK-User-Id: &lt;OAuth client name&gt;\n\n<i>Example</i>: X-LDK-User-Id: Charlie_Brown \n\nIf you are using user-based licensing with a confidential OAuth client, you must add this additional header.\n\nThis custom header contains the name that identifies the user. Before calling the Sentinel LDK Licensing REST API, the application must log into the Sentinel IDP identity provider using the confidential client. \n\nFor more details, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/UG/clients.htm' target='_blank'>OAuth Clients</a>.\n",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-Identity-WS",
            "in": "header",
            "description": "<i>Format</i>: X-LDK-Identity-WS &lt;version&gt;,Identity=&lt;identity_code&gt;,RequestDate=&lt;YYYY-MM-DDTHH:MM:SSZ&gt;,Signature=&lt;web_service_signature&gt; \n\n<i>Example</i>: X-LDK-Identity-WS: V1, Identity=KZMSEU3, RequestDate=2023-08-30T12:36:00Z, Signature=98cd2651598ac9460e8a336912d8bf683c4690d6043ca8a51680143cde080f3c \n\nUse this header for identity string-based licensing, which uses the identity string that is installed on the end user's machine.\n\nFor details on verifying a web service signature, see <a href='index.html?info#signature' target='_blank'>Client Identity-Based Authentication</a>.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-Instance",
            "in": "header",
            "description": "<i>Format</i>:X-LDK-Instance:Identity=&lt;identity_code or user_id or guid&gt;         \n<i>Examples</i>: \nX-LDK-Instance: Identity_Code=KZMSEU3 \nX-LDK-Instance: User-Id=Charlie_Brown \nX-LDK-Instance: GUID=xxxx-xxxx-xxxx-xxxx\n\nUse this header in every request to enable a sticky session to improve the API performance.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "pageStartIndex",
            "in": "query",
            "description": "Starting index of the returned records.",
            "schema": {
              "type": "integer",
              "format": "int32",
              "default": 0
            }
          },
          {
            "name": "pageSize",
            "in": "query",
            "description": "Number of records to return per page.",
            "schema": {
              "type": "integer",
              "format": "int32",
              "default": 10
            }
          },
          {
            "name": "vendorId",
            "in": "path",
            "description": "Unique ID of the software vendor.",
            "required": true,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "OK",
            "content": {
              "application/json": {
                "schema": {
                  "type": "object",
                  "properties": {
                    "memories": {
                      "type": "object",
                      "properties": {
                        "count": {
                          "description": "Total number of records.",
                          "type": "integer",
                          "example": 1
                        },
                        "memory": {
                          "type": "array",
                          "description": "List of available memory files.",
                          "items": {
                            "type": "object",
                            "properties": {
                              "memoryId": {
                                "type": "integer",
                                "description": "File ID for the memory block. Possible values: \n - Default read-only memory file: 65525 \n - Default read/write memory file: 65524 \n - Dynamic memory file: 1-65471",
                                "format": "int32",
                                "example": 65524
                              },
                              "size": {
                                "type": "integer",
                                "description": "Size of the memory block.",
                                "format": "int32",
                                "example": 4032
                              },
                              "attribute": {
                                "type": "string",
                                "description": "Type of memory block. Possible values are: \n - read/write \n - read-only \n - read/write-once (for dynamic memory only)",
                                "example": "read/write"
                              },
                              "keyId": {
                                "type": "string",
                                "description": "Key ID of the Sentinel protection key.",
                                "example": 591751131
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          },
          "401": {
            "description": "Unauthorized"
          },
          "403": {
            "description": "Forbidden"
          },
          "404": {
            "description": "Not Found"
          },
          "422": {
            "description": "Unprocessable Entity. For a list of possible error codes, see <a href='https://docs.sentinel.thalesgroup.com/ldk/LDKdocs/API-licensing/Licensing_API/Enumerations/Licensing_API_Status_Codes.htm' target='_blank'>Sentinel Licensing API Status Codes</a>.\nFor a list of HTTP status code descriptions, see <a href='index.html?info#codes' target='_blank'>HTTP Status Codes</a>.",
            "content": {
              "application/json": {
                "schema": {
                  "type": "object",
                  "properties": {
                    "errorCode": {
                      "type": "integer",
                      "description": "Sentinel Licensing API status codes",
                      "format": "int32",
                      "example": 36
                    },
                    "message": {
                      "type": "string",
                      "description": "Brief description of Sentinel Licensing API Status Codes. For details, see <a href='index.html?info#codes' target='_blank'>HTTP Status Codes</a> and <a href='https://docs.sentinel.thalesgroup.com/ldk/LDKdocs/API-licensing/Licensing_API/Enumerations/Licensing_API_Status_Codes.htm' target='_blank'>Sentinel Licensing API Status Codes</a>.",
                      "example": "HASP_INV_SCOPE"
                    }
                  }
                }
              }
            }
          },
          "429": {
            "description": "Too Many Requests"
          }
        },
        "deprecated": false
      }
    },
    "/sentinel/ldk_runtime/v1/vendors/{vendorId}/sessions/{sessionId}/read": {
      "get": {
        "tags": [
          "memories"
        ],
        "summary": "Read Memory File",
        "description": "Retrieves content from a memory file in a Sentinel protection key. \nFor details on which header(s) to use, see <a href='index.html?info#types' target='_blank'>Types of authentication methods</a>.",
        "operationId": "Read Memory File",
        "parameters": [
          {
            "name": "Authorization",
            "in": "header",
            "description": "<i>Format</i>: Authorization: Bearer &lt;JWT_Token&gt;\n\n<i>Example</i>: Authorization: Bearer eyJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6IC98cd... \n\nUse this header for user-based licensing, which uses login credentials.\n\nThe Sentinel LDK REST API uses the standard HTTP Authorization header to pass the JWT access token. The JWT access token is returned by the Sentinel IDP identity provider after successful authentication using the login credentials of an OAuth client. You create the OAuth client in Sentinel EMS. \n\nFor more details, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/UG/clients.htm#Creating' target='_blank'>Adding an OAuth Client</a>.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-User-Id",
            "in": "header",
            "description": "<i>Format</i>: X-LDK-User-Id: &lt;OAuth client name&gt;\n\n<i>Example</i>: X-LDK-User-Id: Charlie_Brown \n\nIf you are using user-based licensing with a confidential OAuth client, you must add this additional header.\n\nThis custom header contains the name that identifies the user. Before calling the Sentinel LDK Licensing REST API, the application must log into the Sentinel IDP identity provider using the confidential client. \n\nFor more details, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/UG/clients.htm' target='_blank'>OAuth Clients</a>.\n",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-Identity-WS",
            "in": "header",
            "description": "<i>Format</i>: X-LDK-Identity-WS &lt;version&gt;,Identity=&lt;identity_code&gt;,RequestDate=&lt;YYYY-MM-DDTHH:MM:SSZ&gt;,Signature=&lt;web_service_signature&gt; \n\n<i>Example</i>: X-LDK-Identity-WS: V1, Identity=KZMSEU3, RequestDate=2023-08-30T12:36:00Z, Signature=98cd2651598ac9460e8a336912d8bf683c4690d6043ca8a51680143cde080f3c \n\nUse this header for identity string-based licensing, which uses the identity string that is installed on the end user's machine.\n\nFor details on verifying a web service signature, see <a href='index.html?info#signature' target='_blank'>Client Identity-Based Authentication</a>.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-Instance",
            "in": "header",
            "description": "<i>Format</i>:X-LDK-Instance:Identity=&lt;identity_code or user_id or guid&gt;         \n<i>Examples</i>: \nX-LDK-Instance: Identity_Code=KZMSEU3 \nX-LDK-Instance: User-Id=Charlie_Brown \nX-LDK-Instance: GUID=xxxx-xxxx-xxxx-xxxx\n\nUse this header in every request to enable a sticky session to improve the API performance.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "sessionId",
            "in": "path",
            "description": "The session ID.",
            "required": true,
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "vendorId",
            "in": "path",
            "description": "Unique ID of the software vendor.",
            "required": true,
            "example": 37515,
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "memoryId",
            "in": "query",
            "description": "Identifier for the file that is to be read.",
            "required": true,
            "schema": {
              "type": "integer",
              "format": "int32"
            }
          },
          {
            "name": "offset",
            "in": "query",
            "description": "Byte offset of a segment in the file.",
            "required": true,
            "schema": {
              "type": "integer",
              "format": "int32"
            }
          },
          {
            "name": "length",
            "in": "query",
            "description": "Length of the segment (in bytes) to be read from the file.",
            "required": true,
            "schema": {
              "type": "integer",
              "format": "int32"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "OK",
            "content": {
              "application/json": {
                "schema": {
                  "type": "object",
                  "properties": {
                    "content": {
                      "type": "string",
                      "description": "Content of the memory file in Base64 format.",
                      "example": "U2FtcGxlUlcxMjM0NTY3ODk"
                    }
                  }
                }
              }
            }
          },
          "401": {
            "description": "Unauthorized"
          },
          "403": {
            "description": "Forbidden"
          },
          "404": {
            "description": "Not Found"
          },
          "422": {
            "description": "Unprocessable Entity. For a list of possible error codes, see <a href='https://docs.sentinel.thalesgroup.com/ldk/LDKdocs/API-licensing/Licensing_API/Enumerations/Licensing_API_Status_Codes.htm' target='_blank'>Sentinel Licensing API Status Codes</a>.\nFor a list of HTTP status code descriptions, see <a href='index.html?info#codes' target='_blank'>HTTP Status Codes</a>.",
            "content": {
              "application/json": {
                "schema": {
                  "type": "object",
                  "properties": {
                    "errorCode": {
                      "type": "integer",
                      "description": "Sentinel Licensing API status codes",
                      "format": "int32",
                      "example": 36
                    },
                    "message": {
                      "type": "string",
                      "description": "Brief description of Sentinel Licensing API Status Codes. For details, see <a href='index.html?info#codes' target='_blank'>HTTP Status Codes</a> and <a href='https://docs.sentinel.thalesgroup.com/ldk/LDKdocs/API-licensing/Licensing_API/Enumerations/Licensing_API_Status_Codes.htm' target='_blank'>Sentinel Licensing API Status Codes</a>.",
                      "example": "HASP_INV_SCOPE"
                    }
                  }
                }
              }
            }
          },
          "429": {
            "description": "Too Many Requests"
          }
        },
        "deprecated": false
      }
    },
    "/sentinel/ldk_runtime/v1/vendors/{vendorId}/products": {
      "get": {
        "tags": [
          "products"
        ],
        "summary": "Get Product List",
        "description": "Retrieve a list of all products for the specified vendor. \nFor details on which header(s) to use, see <a href='index.html?info#types' target='_blank'>Types of authentication methods</a>.",
        "operationId": "Get Product List",
        "parameters": [
          {
            "name": "Authorization",
            "in": "header",
            "description": "<i>Format</i>: Authorization: Bearer &lt;JWT_Token&gt;\n\n<i>Example</i>: Authorization: Bearer eyJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6IC98cd... \n\nUse this header for user-based licensing, which uses login credentials.\n\nThe Sentinel LDK REST API uses the standard HTTP Authorization header to pass the JWT access token. The JWT access token is returned by the Sentinel IDP identity provider after successful authentication using the login credentials of an OAuth client. You create the OAuth client in Sentinel EMS. \n\nFor more details, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/UG/clients.htm#Creating' target='_blank'>Adding an OAuth Client</a>.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-User-Id",
            "in": "header",
            "description": "<i>Format</i>: X-LDK-User-Id: &lt;OAuth client name&gt;\n\n<i>Example</i>: X-LDK-User-Id: Charlie_Brown \n\nIf you are using user-based licensing with a confidential OAuth client, you must add this additional header.\n\nThis custom header contains the name that identifies the user. Before calling the Sentinel LDK Licensing REST API, the application must log into the Sentinel IDP identity provider using the confidential client. \n\nFor more details, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/UG/clients.htm' target='_blank'>OAuth Clients</a>.\n",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-Identity-WS",
            "in": "header",
            "description": "<i>Format</i>: X-LDK-Identity-WS &lt;version&gt;,Identity=&lt;identity_code&gt;,RequestDate=&lt;YYYY-MM-DDTHH:MM:SSZ&gt;,Signature=&lt;web_service_signature&gt; \n\n<i>Example</i>: X-LDK-Identity-WS: V1, Identity=KZMSEU3, RequestDate=2023-08-30T12:36:00Z, Signature=98cd2651598ac9460e8a336912d8bf683c4690d6043ca8a51680143cde080f3c \n\nUse this header for identity string-based licensing, which uses the identity string that is installed on the end user's machine.\n\nFor details on verifying a web service signature, see <a href='index.html?info#signature' target='_blank'>Client Identity-Based Authentication</a>.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-Instance",
            "in": "header",
            "description": "<i>Format</i>:X-LDK-Instance:Identity=&lt;identity_code or user_id or guid&gt;         \n<i>Examples</i>: \nX-LDK-Instance: Identity_Code=KZMSEU3 \nX-LDK-Instance: User-Id=Charlie_Brown \nX-LDK-Instance: GUID=xxxx-xxxx-xxxx-xxxx\n\nUse this header in every request to enable a sticky session to improve the API performance.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "pageStartIndex",
            "in": "query",
            "description": "Starting index of the returned records.",
            "schema": {
              "type": "integer",
              "format": "int32",
              "default": 0
            }
          },
          {
            "name": "pageSize",
            "in": "query",
            "description": "Number of records to return per page.",
            "schema": {
              "type": "integer",
              "format": "int32",
              "default": 10
            }
          },
          {
            "name": "vendorId",
            "in": "path",
            "description": "Unique ID of the software vendor.",
            "required": true,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "OK",
            "content": {
              "application/json": {
                "schema": {
                  "type": "object",
                  "properties": {
                    "products": {
                      "type": "object",
                      "properties": {
                        "count": {
                          "description": "Total number of records.",
                          "type": "integer",
                          "example": 1
                        },
                        "product": {
                          "type": "array",
                          "items": {
                            "type": "object",
                            "properties": {
                              "cloneProtected": {
                                "type": "boolean",
                                "description": "Whether clone protection is enabled for SL licenses. \n Possible return values: \n - true \n - false"
                              },
                              "detachable": {
                                "type": "boolean",
                                "description": "Whether the license for the Product can be detached from the network pool."
                              },
                              "fingerprintChanged": {
                                "type": "boolean",
                                "description": "Whether a Product is locked to a Sentinel SL key for which cloning is detected. \n Possible return values:  \n - true \n - false"
                              },
                              "productId": {
                                "type": "integer",
                                "description": "ID of the Product.",
                                "format": "int32",
                                "example": 101
                              },
                              "keyId": {
                                "type": "integer",
                                "description": "Key ID of the Sentinel protection key.",
                                "format": "int64",
                                "example": 642540805756861300
                              },
                              "name": {
                                "type": "string",
                                "description": "Name of the Product.",
                                "example": "design"
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          },
          "401": {
            "description": "Unauthorized"
          },
          "403": {
            "description": "Forbidden"
          },
          "404": {
            "description": "Not Found"
          },
          "422": {
            "description": "Unprocessable Entity. For a list of possible error codes, see <a href='https://docs.sentinel.thalesgroup.com/ldk/LDKdocs/API-licensing/Licensing_API/Enumerations/Licensing_API_Status_Codes.htm' target='_blank'>Sentinel Licensing API Status Codes</a>.\nFor a list of HTTP status code descriptions, see <a href='index.html?info#codes' target='_blank'>HTTP Status Codes</a>.",
            "content": {
              "application/json": {
                "schema": {
                  "type": "object",
                  "properties": {
                    "errorCode": {
                      "type": "integer",
                      "description": "Sentinel Licensing API status codes",
                      "format": "int32",
                      "example": 36
                    },
                    "message": {
                      "type": "string",
                      "description": "Brief description of Sentinel Licensing API Status Codes. For details, see <a href='index.html?info#codes' target='_blank'>HTTP Status Codes</a> and <a href='https://docs.sentinel.thalesgroup.com/ldk/LDKdocs/API-licensing/Licensing_API/Enumerations/Licensing_API_Status_Codes.htm' target='_blank'>Sentinel Licensing API Status Codes</a>.",
                      "example": "HASP_INV_SCOPE"
                    }
                  }
                }
              }
            }
          },
          "429": {
            "description": "Too Many Requests"
          }
        },
        "deprecated": false
      }
    },
    "/sentinel/ldk_runtime/v1/vendors/{vendorId}/sessions": {
      "post": {
        "tags": [
          "sessions"
        ],
        "summary": "Create Session",
        "operationId": "Create Session",
        "description": "Open a session to enable an authorized user to access features in the licensed application. This establishes a session context.  \nFor details on which header(s) to use, see <a href='index.html?info#types' target='_blank'>Types of authentication methods</a>.\n\nYou can create sessions for <i>user-based licensing</i> or <i>identity string-based licensing</i>. \n\n<b>User-based licensing.</b> Authenticates using OAuth. You provide login credentials to end users. End users can then run your protected applications using the login credentials that you provide. This is recommended for server-side web applications, where the API is called on behalf of the application.  \nFor an overview of the various OAuth workflows that you can use when defining OAuth clients in Sentinel EMS and when using OAuth with the Sentinel REST APIs, including the Sentinel LDK Licensing REST API and Sentinel EMS REST API, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/UG/clients-workflow.htm' target='_blank'>Sentinel EMS Workflow with OAuth Clients</a>.\nFor a general introduction to OAuth clients when using the Sentinel REST APIs, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/UG/clients.htm' target='_blank'>OAuth Clients</a>. \n<b>Note:</b> If your application's backend service uses confidential credentials, you must pass an additional header that includes the user ID. \n\n <b>Identity string-based licensing.</b> Authenticates users using identity strings that are installed on the end user machines. Identity strings are used for license verification, allowing protected applications to run on those machines. You distribute a unique identity string to each user, who then installs that identity string on their respective machine. When using Sentinel EMS, you use <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/LDK-UG/Default.htm#cshid=1117' target='_blank'>machine accounts</a> to handle identity string-based licensing.",
        "parameters": [
          {
            "name": "Authorization",
            "in": "header",
            "description": "<i>Format</i>: Authorization: Bearer &lt;JWT_Token&gt;\n\n<i>Example</i>: Authorization: Bearer eyJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6IC98cd... \n\nUse this header for user-based licensing, which uses login credentials.\n\nThe Sentinel LDK REST API uses the standard HTTP Authorization header to pass the JWT access token. The JWT access token is returned by the Sentinel IDP identity provider after successful authentication using the login credentials of an OAuth client. You create the OAuth client in Sentinel EMS. \n\nFor more details, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/UG/clients.htm#Creating' target='_blank'>Adding an OAuth Client</a>.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-User-Id",
            "in": "header",
            "description": "<i>Format</i>: X-LDK-User-Id: &lt;OAuth client name&gt;\n\n<i>Example</i>: X-LDK-User-Id: Charlie_Brown \n\nIf you are using user-based licensing with a confidential OAuth client, you must add this additional header.\n\nThis custom header contains the name that identifies the user. Before calling the Sentinel LDK Licensing REST API, the application must log into the Sentinel IDP identity provider using the confidential client. \n\nFor more details, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/UG/clients.htm' target='_blank'>OAuth Clients</a>.\n",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-Identity-WS",
            "in": "header",
            "description": "<i>Format</i>: X-LDK-Identity-WS &lt;version&gt;,Identity=&lt;identity_code&gt;,RequestDate=&lt;YYYY-MM-DDTHH:MM:SSZ&gt;,Signature=&lt;web_service_signature&gt; \n\n<i>Example</i>: X-LDK-Identity-WS: V1, Identity=KZMSEU3, RequestDate=2023-08-30T12:36:00Z, Signature=98cd2651598ac9460e8a336912d8bf683c4690d6043ca8a51680143cde080f3c \n\nUse this header for identity string-based licensing, which uses the identity string that is installed on the end user's machine.\n\nFor details on verifying a web service signature, see <a href='index.html?info#signature' target='_blank'>Client Identity-Based Authentication</a>.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-Instance",
            "in": "header",
            "description": "<i>Format</i>:X-LDK-Instance:Identity=&lt;identity_code or user_id or guid&gt;         \n<i>Examples</i>: \nX-LDK-Instance: Identity_Code=KZMSEU3 \nX-LDK-Instance: User-Id=Charlie_Brown \nX-LDK-Instance: GUID=xxxx-xxxx-xxxx-xxxx\n\nUse this header in every request to enable a sticky session to improve the API performance.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "vendorId",
            "in": "path",
            "description": "Unique ID of the software vendor.",
            "required": true,
            "example": 37515,
            "schema": {
              "type": "string"
            }
          }
        ],
        "requestBody": {
          "description": "Details of the session to be created",
          "content": {
            "application/json": {
              "schema": {
                "type": "object",
                "properties": {
                  "featureId": {
                    "type": "integer",
                    "description": "User-defined unique identifier for a specific Feature stored in a Sentinel protection key. This number is passed to the Create Session method to establish access to the Feature.",
                    "format": "int32",
                    "example": 123
                  },
                  "clientInfo": {
                    "type": "object",
                    "properties": {
                      "domainName": {
                        "type": "string",
                        "description": "Domain name of the client machine.",
                        "example": "example.com"
                      },
                      "hostName": {
                        "type": "string",
                        "description": "Computer name of the client machine.",
                        "example": "computer-name"
                      },
                      "userName": {
                        "type": "string",
                        "description": "Name of the user currently logged into the computer.",
                        "example": "username"
                      },
                      "machineId": {
                        "type": "string",
                        "description": "Unique identifier of the computer. This ID is used to: \n - identify the computer as a registered machine \n - identify the computer as a station for concurrency instances",
                        "example": "machine-123456"
                      },
                      "processId": {
                        "type": "string",
                        "description": "Unique identifier for the running process. This ID is used to identify the process for concurrency instances.",
                        "example": 987321
                      },
                      "clientDateTime": {
                        "type": "string",
                        "description": "System date and time on the client machine.",
                        "format": "date-time",
                        "example": "2023-07-21T09:15:30.000Z"
                      }
                    }
                  },
                  "scope": {
                    "type": "object",
                    "properties": {
                      "keyId": {
                        "type": "array",
                        "items": {
                          "type": "integer"
                        },
                        "example": "[642540805756861288, 325879014527852364]"
                      },
                      "productId": {
                        "type": "array",
                        "items": {
                          "type": "integer"
                        },
                        "example": "[101]"
                      }
                    }
                  },
                  "dieAtExpiration": {
                    "type": "boolean",
                    "description": "Whether the current session should be terminated if the expiration date of the current Feature has passed. \n Possible values:\n - false (allow the session to continue (default))\n - true (terminate the session)"
                  },
                  "executionCountToConsume": {
                    "type": "integer",
                    "description": "Number of executions to consume from a single pool of executions in the license for a single login. A typical use case is to assign a different cost in executions for different functions in an application. For example, the customer could be charged one execution for a Save operation and three executions for a Print operation.",
                    "format": "int32",
                    "example": 1
                  },
                  "networkSeatsToConsume": {
                    "type": "integer",
                    "description": "Number of network seats to consume.\n Note: \n - Sentinel Admin Control Center displays a single session with the specified number of seats.\n - Login succeeds if a Feature with unlimited network seats is available.\n - Login fails if no single Feature within a given Product contains the required number of network seats.\n - For execution count licenses: One execution count is consumed for each login regardless of the number of network seats to be consumed.\n - Count criteria: \n For Login: Seats are consumed for each login scope API call. \n For Process or Station: Seats are consumed once per instance.",
                    "format": "int32",
                    "example": 1
                  },
                  "fullInfo": {
                    "type": "boolean",
                    "description": "Whether to display all information for the Feature and Product.\n Possible values:\n - true \n - false",
                    "example": false
                  }
                }
              }
            }
          },
          "required": true
        },
        "responses": {
          "201": {
            "description": "Created",
            "content": {
              "application/json": {
                "schema": {
                  "type": "object",
                  "properties": {
                    "sessionId": {
                      "type": "string",
                      "description": "Unique session ID",
                      "example": 1422578489
                    },
                    "sessionInfo": {
                      "type": "object",
                      "properties": {
                        "currentLogins": {
                          "type": "integer",
                          "description": "Number of open sessions connected to the Feature/application.",
                          "format": "int32",
                          "example": 1
                        },
                        "keepAliveTimeout": {
                          "type": "integer",
                          "description": "The maximum time in seconds that the license manager server holds the session if the session is not refreshed. Default values:\n - OAuth- or identity string-based authentication: 900 (15 minutes)\n - Otherwise: 180 (3 minutes)",
                          "format": "int32",
                          "example": 900
                        },
                        "idleTimeout": {
                          "type": "integer",
                          "description": "Total amount of time in seconds that the session can be idle before the session is terminated. Default values: \n - Thales-hosted (OAuth- or identity string-based authentication (machine accounts only)): 0 (no idle timeout)\n - Otherwise: 43200 (12 hours)",
                          "format": "int32",
                          "example": 0
                        }
                      }
                    },
                    "featureId": {
                      "type": "integer",
                      "description": "User-defined unique identifier for a specific Feature stored in a Sentinel protection key. This number is passed to the Create Session method to establish access to the Feature.",
                      "format": "int32",
                      "example": 1
                    },
                    "productId": {
                      "type": "integer",
                      "description": "ID of the Product.",
                      "format": "int32",
                      "example": 1
                    },
                    "keyId": {
                      "type": "integer",
                      "description": "Key ID of the Sentinel protection key.",
                      "example": 642540805756861300
                    }
                  }
                }
              }
            }
          },
          "401": {
            "description": "Unauthorized"
          },
          "403": {
            "description": "Forbidden"
          },
          "404": {
            "description": "Not Found"
          },
          "422": {
            "description": "Unprocessable Entity. For a list of possible error codes, see <a href='https://docs.sentinel.thalesgroup.com/ldk/LDKdocs/API-licensing/Licensing_API/Enumerations/Licensing_API_Status_Codes.htm' target='_blank'>Sentinel Licensing API Status Codes</a>.\nFor a list of HTTP status code descriptions, see <a href='index.html?info#codes' target='_blank'>HTTP Status Codes</a>.",
            "content": {
              "application/json": {
                "schema": {
                  "type": "object",
                  "properties": {
                    "errorCode": {
                      "type": "integer",
                      "description": "Sentinel Licensing API status codes",
                      "format": "int32",
                      "example": 36
                    },
                    "message": {
                      "type": "string",
                      "description": "Brief description of Sentinel Licensing API Status Codes. For details, see <a href='index.html?info#codes' target='_blank'>HTTP Status Codes</a> and <a href='https://docs.sentinel.thalesgroup.com/ldk/LDKdocs/API-licensing/Licensing_API/Enumerations/Licensing_API_Status_Codes.htm' target='_blank'>Sentinel Licensing API Status Codes</a>.",
                      "example": "HASP_INV_SCOPE"
                    }
                  }
                }
              }
            }
          },
          "429": {
            "description": "Too Many Requests"
          }
        },
        "deprecated": false,
        "x-codegen-request-body-name": "licenseRequest"
      }
    },
    "/sentinel/ldk_runtime/v1/vendors/{vendorId}/sessions/{sessionId}": {
      "delete": {
        "tags": [
          "sessions"
        ],
        "summary": "Delete Session",
        "description": "Log out of a session to release the license authorization session of a feature. \nFor details on which header(s) to use, see <a href='index.html?info#types' target='_blank'>Types of authentication methods</a>.",
        "operationId": "Delete Session",
        "parameters": [
          {
            "name": "Authorization",
            "in": "header",
            "description": "<i>Format</i>: Authorization: Bearer &lt;JWT_Token&gt;\n\n<i>Example</i>: Authorization: Bearer eyJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6IC98cd... \n\nUse this header for user-based licensing, which uses login credentials.\n\nThe Sentinel LDK REST API uses the standard HTTP Authorization header to pass the JWT access token. The JWT access token is returned by the Sentinel IDP identity provider after successful authentication using the login credentials of an OAuth client. You create the OAuth client in Sentinel EMS. \n\nFor more details, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/UG/clients.htm#Creating' target='_blank'>Adding an OAuth Client</a>.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-User-Id",
            "in": "header",
            "description": "<i>Format</i>: X-LDK-User-Id: &lt;OAuth client name&gt;\n\n<i>Example</i>: X-LDK-User-Id: Charlie_Brown \n\nIf you are using user-based licensing with a confidential OAuth client, you must add this additional header.\n\nThis custom header contains the name that identifies the user. Before calling the Sentinel LDK Licensing REST API, the application must log into the Sentinel IDP identity provider using the confidential client. \n\nFor more details, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/UG/clients.htm' target='_blank'>OAuth Clients</a>.\n",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-Identity-WS",
            "in": "header",
            "description": "<i>Format</i>: X-LDK-Identity-WS &lt;version&gt;,Identity=&lt;identity_code&gt;,RequestDate=&lt;YYYY-MM-DDTHH:MM:SSZ&gt;,Signature=&lt;web_service_signature&gt; \n\n<i>Example</i>: X-LDK-Identity-WS: V1, Identity=KZMSEU3, RequestDate=2023-08-30T12:36:00Z, Signature=98cd2651598ac9460e8a336912d8bf683c4690d6043ca8a51680143cde080f3c \n\nUse this header for identity string-based licensing, which uses the identity string that is installed on the end user's machine.\n\nFor details on verifying a web service signature, see <a href='index.html?info#signature' target='_blank'>Client Identity-Based Authentication</a>.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-Instance",
            "in": "header",
            "description": "<i>Format</i>:X-LDK-Instance:Identity=&lt;identity_code or user_id or guid&gt;         \n<i>Examples</i>: \nX-LDK-Instance: Identity_Code=KZMSEU3 \nX-LDK-Instance: User-Id=Charlie_Brown \nX-LDK-Instance: GUID=xxxx-xxxx-xxxx-xxxx\n\nUse this header in every request to enable a sticky session to improve the API performance.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "sessionId",
            "in": "path",
            "description": "The session ID.",
            "required": true,
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "vendorId",
            "in": "path",
            "description": "Unique ID of the software vendor.",
            "required": true,
            "example": 37515,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "No Content",
            "content": {}
          },
          "401": {
            "description": "Unauthorized"
          },
          "403": {
            "description": "Forbidden"
          },
          "404": {
            "description": "Not Found"
          },
          "422": {
            "description": "Unprocessable Entity. For a list of possible error codes, see <a href='https://docs.sentinel.thalesgroup.com/ldk/LDKdocs/API-licensing/Licensing_API/Enumerations/Licensing_API_Status_Codes.htm' target='_blank'>Sentinel Licensing API Status Codes</a>.\nFor a list of HTTP status code descriptions, see <a href='index.html?info#codes' target='_blank'>HTTP Status Codes</a>.",
            "content": {
              "application/json": {
                "schema": {
                  "type": "object",
                  "properties": {
                    "errorCode": {
                      "type": "integer",
                      "description": "Sentinel Licensing API status codes",
                      "format": "int32",
                      "example": 36
                    },
                    "message": {
                      "type": "string",
                      "description": "Brief description of Sentinel Licensing API Status Codes. For details, see <a href='index.html?info#codes' target='_blank'>HTTP Status Codes</a> and <a href='https://docs.sentinel.thalesgroup.com/ldk/LDKdocs/API-licensing/Licensing_API/Enumerations/Licensing_API_Status_Codes.htm' target='_blank'>Sentinel Licensing API Status Codes</a>.",
                      "example": "HASP_INV_SCOPE"
                    }
                  }
                }
              }
            }
          },
          "429": {
            "description": "Too Many Requests"
          }
        },
        "deprecated": false
      }
    },
    "/sentinel/ldk_runtime/v1/vendors/{vendorId}/sessions/{sessionId}/refresh": {
      "post": {
        "tags": [
          "sessions"
        ],
        "summary": "Refresh Session",
        "description": "Notify the server that the session is still alive. \nFor details on which header(s) to use, see <a href='index.html?info#types' target='_blank'>Types of authentication methods</a>.",
        "operationId": "Refresh Session",
        "parameters": [
          {
            "name": "Authorization",
            "in": "header",
            "description": "<i>Format</i>: Authorization: Bearer &lt;JWT_Token&gt;\n\n<i>Example</i>: Authorization: Bearer eyJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6IC98cd... \n\nUse this header for user-based licensing, which uses login credentials.\n\nThe Sentinel LDK REST API uses the standard HTTP Authorization header to pass the JWT access token. The JWT access token is returned by the Sentinel IDP identity provider after successful authentication using the login credentials of an OAuth client. You create the OAuth client in Sentinel EMS. \n\nFor more details, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/UG/clients.htm#Creating' target='_blank'>Adding an OAuth Client</a>.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-User-Id",
            "in": "header",
            "description": "<i>Format</i>: X-LDK-User-Id: &lt;OAuth client name&gt;\n\n<i>Example</i>: X-LDK-User-Id: Charlie_Brown \n\nIf you are using user-based licensing with a confidential OAuth client, you must add this additional header.\n\nThis custom header contains the name that identifies the user. Before calling the Sentinel LDK Licensing REST API, the application must log into the Sentinel IDP identity provider using the confidential client. \n\nFor more details, see <a href='https://docs.sentinel.thalesgroup.com/softwareandservices/ems/EMSdocs/UG/clients.htm' target='_blank'>OAuth Clients</a>.\n",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-Identity-WS",
            "in": "header",
            "description": "<i>Format</i>: X-LDK-Identity-WS &lt;version&gt;,Identity=&lt;identity_code&gt;,RequestDate=&lt;YYYY-MM-DDTHH:MM:SSZ&gt;,Signature=&lt;web_service_signature&gt; \n\n<i>Example</i>: X-LDK-Identity-WS: V1, Identity=KZMSEU3, RequestDate=2023-08-30T12:36:00Z, Signature=98cd2651598ac9460e8a336912d8bf683c4690d6043ca8a51680143cde080f3c \n\nUse this header for identity string-based licensing, which uses the identity string that is installed on the end user's machine.\n\nFor details on verifying a web service signature, see <a href='index.html?info#signature' target='_blank'>Client Identity-Based Authentication</a>.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "X-LDK-Instance",
            "in": "header",
            "description": "<i>Format</i>:X-LDK-Instance:Identity=&lt;identity_code or user_id or guid&gt;         \n<i>Examples</i>: \nX-LDK-Instance: Identity_Code=KZMSEU3 \nX-LDK-Instance: User-Id=Charlie_Brown \nX-LDK-Instance: GUID=xxxx-xxxx-xxxx-xxxx\n\nUse this header in every request to enable a sticky session to improve the API performance.",
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "sessionId",
            "in": "path",
            "description": "The session ID.",
            "required": true,
            "schema": {
              "type": "string"
            }
          },
          {
            "name": "vendorId",
            "in": "path",
            "description": "Unique ID of the software vendor.",
            "required": true,
            "example": 37515,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "OK",
            "content": {
              "application/json": {
                "schema": {
                  "type": "object",
                  "properties": {
                    "sessionId": {
                      "type": "string",
                      "description": "Unique session ID",
                      "example": 1422578489
                    },
                    "sessionInfo": {
                      "type": "object",
                      "properties": {
                        "currentLogins": {
                          "type": "integer",
                          "description": "Number of open sessions connected to the Feature/application.",
                          "format": "int32",
                          "example": 1
                        },
                        "keepAliveTimeout": {
                          "type": "integer",
                          "description": "The maximum time in seconds that the license manager server holds the session if the session is not refreshed. Default values:\n - OAuth- or identity string-based authentication: 900 (15 minutes)\n - Otherwise: 180 (3 minutes)",
                          "format": "int32",
                          "example": 900
                        },
                        "idleTimeout": {
                          "type": "integer",
                          "description": "Total amount of time in seconds that the session can be idle before the session is terminated. Default values: \n - Thales-hosted (OAuth- or identity string-based authentication (machine accounts only)): 0 (no idle timeout)\n - Otherwise: 43200 (12 hours)",
                          "format": "int32",
                          "example": 0
                        }
                      }
                    },
                    "featureId": {
                      "type": "integer",
                      "description": "User-defined unique identifier for a specific Feature stored in a Sentinel protection key. This number is passed to the Create Session method to establish access to the Feature.",
                      "format": "int32",
                      "example": 1
                    },
                    "productId": {
                      "type": "integer",
                      "description": "ID of the Product.",
                      "format": "int32",
                      "example": 1
                    },
                    "keyId": {
                      "type": "integer",
                      "description": "Key ID of the Sentinel protection key.",
                      "example": 642540805756861300
                    }
                  }
                }
              }
            }
          },
          "401": {
            "description": "Unauthorized"
          },
          "403": {
            "description": "Forbidden"
          },
          "404": {
            "description": "Not Found"
          },
          "422": {
            "description": "Unprocessable Entity. For a list of possible error codes, see <a href='https://docs.sentinel.thalesgroup.com/ldk/LDKdocs/API-licensing/Licensing_API/Enumerations/Licensing_API_Status_Codes.htm' target='_blank'>Sentinel Licensing API Status Codes</a>.\nFor a list of HTTP status code descriptions, see <a href='index.html?info#codes' target='_blank'>HTTP Status Codes</a>.",
            "content": {
              "application/json": {
                "schema": {
                  "type": "object",
                  "properties": {
                    "errorCode": {
                      "type": "integer",
                      "description": "Sentinel Licensing API status codes",
                      "format": "int32",
                      "example": 36
                    },
                    "message": {
                      "type": "string",
                      "description": "Brief description of Sentinel Licensing API Status Codes. For details, see <a href='index.html?info#codes' target='_blank'>HTTP Status Codes</a> and <a href='https://docs.sentinel.thalesgroup.com/ldk/LDKdocs/API-licensing/Licensing_API/Enumerations/Licensing_API_Status_Codes.htm' target='_blank'>Sentinel Licensing API Status Codes</a>.",
                      "example": "HASP_INV_SCOPE"
                    }
                  }
                }
              }
            }
          },
          "429": {
            "description": "Too Many Requests"
          }
        },
        "deprecated": false
      }
    }
  },
  "footer": "<div style=\"border: 1px solid #d2d4d6;padding: .167rem 15px;font-size: .74375rem;color: #797979;\">Copyright <i class=\"far fa-copyright\" style=\"font-size: 10px;\"></i> 2009-2024 THALES. All rights reserved. | <a target=\"_blank\" href=\"https://supportportal.thalesgroup.com/csm/\">Support</a></div>"
}