#! /bin/sh

echo "Building Java Samples"

rm -rf bin
rm -f java-ws-demo.jar

mkdir bin
javac -classpath ./bin:lib/commons-logging-1.2.jar:lib/httpclient-4.5.9.jar:lib/httpcore-4.4.11.jar:lib/commons-logging-1.2.jar:lib/httpclient-4.5.9.jar:lib/httpcore-4.4.11.jar:lib/gson-2.9.1.jar -d ./bin  -Xlint:deprecation ./src/com/sfnt/ldk/util/*.java ./src/com/sfnt/ldk/model/*.java ./src/com/sfnt/ldk/api/*.java ./src/com/sfnt/ldk/sample/*.java
javac -cp lib/commons-logging-1.2.jar:lib/httpclient-4.5.9.jar:lib/httpcore-4.4.11.jar -d bin -Xlint:deprecation src/com/sfnt/ldk/util/ServiceUtil.java
javac -d bin src/com/sfnt/ldk/util/HmacSHA256Util.java
javac -d bin src/com/sfnt/ldk/model/ClientInfo.java
javac -d bin src/com/sfnt/ldk/model/Concurrency.java
javac -d bin src/com/sfnt/ldk/model/ErrorInfo.java
javac -d bin src/com/sfnt/ldk/model/LicenseInfo.java
javac -cp .:bin -d bin src/com/sfnt/ldk/model/FeatureInfo.java
javac -cp .:bin -d bin src/com/sfnt/ldk/model/Features.java
javac -cp .:bin -d bin src/com/sfnt/ldk/model/FeaturesResponse.java
javac -d bin src/com/sfnt/ldk/model/KeyInfo.java
javac -cp .:bin -d bin src/com/sfnt/ldk/model/Keys.java
javac -cp .:bin -d bin src/com/sfnt/ldk/model/KeysResponse.java
javac -d bin src/com/sfnt/ldk/model/Scope.java
javac -cp .:bin -d bin src/com/sfnt/ldk/model/LicenseRequest.java
javac -d bin src/com/sfnt/ldk/model/SessionInfo.java
javac -d bin src/com/sfnt/ldk/model/LicenseResponseKeyInfo.java
javac -d bin src/com/sfnt/ldk/model/ProductInfo.java
javac -cp .:bin -d bin src/com/sfnt/ldk/model/Products.java
javac -cp .:bin -d bin src/com/sfnt/ldk/model/ProductsResponse.java
javac -cp .:bin -d bin src/com/sfnt/ldk/model/LicenseResponse.java
javac -d bin src/com/sfnt/ldk/model/LogoutResponse.java
javac -cp .:bin -d bin src/com/sfnt/ldk/model/MemoryInfo.java
javac -cp .:bin -d bin src/com/sfnt/ldk/model/Memories.java
javac -cp .:bin -d bin src/com/sfnt/ldk/model/MemoriesResponse.java
javac -cp .:bin -d bin src/com/sfnt/ldk/model/ReadMemoryResponse.java
javac -cp .:bin:lib/commons-logging-1.2.jar:lib/httpclient-4.5.9.jar:lib/httpcore-4.4.11.jar:lib/gson-2.9.1.jar -d bin src/com/sfnt/ldk/api/LdkRuntimeRestAPI.java
javac -cp .:bin -d bin src/com/sfnt/ldk/sample/AccessTokenInfo.java
javac -cp .:bin:lib/httpclient-4.5.9.jar:lib/httpcore-4.4.11.jar:lib/gson-2.9.1.jar -d bin src/com/sfnt/ldk/sample/Sample.java
jar cvfm java-ws-demo.jar MANIFEST.MF -C bin/ .


