package com.sfnt.ldk.model;

import java.util.Objects;

/**
 * ClientInfo
 */
public class ClientInfo {
	private String domainName = null;
	private String hostName = null;
	private String userName = null;
	private String machineId = null;
	private String processId = null;
	private String clientDateTime = null;

	public ClientInfo domainName(String domainName) {
		this.domainName = domainName;
		return this;
	}

	/**
	 * Get domainName
	 * 
	 * @return domainName
	 **/
	public String getDomainName() {
		return domainName;
	}

	public void setDomainName(String domainName) {
		this.domainName = domainName;
	}

	public ClientInfo hostName(String hostName) {
		this.hostName = hostName;
		return this;
	}

	/**
	 * Get hostName
	 * 
	 * @return hostName
	 **/
	public String getHostName() {
		return hostName;
	}

	public void setHostName(String hostName) {
		this.hostName = hostName;
	}

	public ClientInfo userName(String userName) {
		this.userName = userName;
		return this;
	}

	/**
	 * Get userName
	 * 
	 * @return userName
	 **/
	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public ClientInfo machineId(String machineId) {
		this.machineId = machineId;
		return this;
	}

	/**
	 * Get machineId
	 * 
	 * @return machineId
	 **/
	public String getMachineId() {
		return machineId;
	}

	public void setMachineId(String machineId) {
		this.machineId = machineId;
	}

	public ClientInfo processId(String processId) {
		this.processId = processId;
		return this;
	}

	/**
	 * Get processId
	 * 
	 * @return processId
	 **/
	public String getProcessId() {
		return processId;
	}

	public void setProcessId(String processId) {
		this.processId = processId;
	}

	public ClientInfo clientDateTime(String clientDateTime) {
		this.clientDateTime = clientDateTime;
		return this;
	}

	/**
	 * client side date and time
	 * 
	 * @return clientDateTime
	 **/
	public String getClientDateTime() {
		return clientDateTime;
	}

	public void setClientDateTime(String clientDateTime) {
		this.clientDateTime = clientDateTime;
	}

	@Override
	public boolean equals(java.lang.Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		ClientInfo clientInfo = (ClientInfo) o;
		return Objects.equals(this.domainName, clientInfo.domainName)
				&& Objects.equals(this.hostName, clientInfo.hostName)
				&& Objects.equals(this.userName, clientInfo.userName)
				&& Objects.equals(this.machineId, clientInfo.machineId)
				&& Objects.equals(this.processId, clientInfo.processId)
				&& Objects.equals(this.clientDateTime, clientInfo.clientDateTime);
	}

	@Override
	public int hashCode() {
		return Objects.hash(domainName, hostName, userName, machineId, processId, clientDateTime);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("{\n");
		if (domainName != null)
			sb.append("\"domainName\": \"").append(toIndentedString(domainName)).append("\",\n");
		if (hostName != null)
			sb.append("\"hostName\": \"").append(toIndentedString(hostName)).append("\",\n");
		if (userName != null)
			sb.append("\"userName\": \"").append(toIndentedString(userName)).append("\",\n");
		if (machineId != null)
			sb.append("\"machineId\": \"").append(toIndentedString(machineId)).append("\",\n");
		if (processId != null)
			sb.append("\"processId\": \"").append(toIndentedString(processId)).append("\",\n");
		if (clientDateTime != null)
			sb.append("\"clientDateTime\": \"").append(toIndentedString(clientDateTime)).append("\"\n");
		sb.append("}");
		return sb.toString();
	}

	/**
	 * Convert the given object to string with each line indented by 4 spaces
	 * (except the first line).
	 */
	private String toIndentedString(java.lang.Object o) {
		if (o == null) {
			return "null";
		}
		return o.toString().replace("\n", "\n    ");
	}

}
