package com.sfnt.ldk.model;

import java.util.Objects;


/**
 * Concurrency
 */
public class Concurrency {
  private String count = null;
  private String export = null;
  private Integer seats = null;

  public Concurrency count(String count) {
    this.count = count;
    return this;
  }

   /**
   * Get count
   * @return count
  **/
  public String getCount() {
    return count;
  }

  public void setCount(String count) {
    this.count = count;
  }

  public Concurrency export(String export) {
    this.export = export;
    return this;
  }

   /**
   * Get export
   * @return export
  **/
  public String getExport() {
    return export;
  }

  public void setExport(String export) {
    this.export = export;
  }

  public Concurrency seats(Integer seats) {
    this.seats = seats;
    return this;
  }

   /**
   * Get seats
   * @return seats
  **/
  public Integer getSeats() {
    return seats;
  }

  public void setSeats(Integer seats) {
    this.seats = seats;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Concurrency concurrency = (Concurrency) o;
    return Objects.equals(this.count, concurrency.count) &&
        Objects.equals(this.export, concurrency.export) &&
        Objects.equals(this.seats, concurrency.seats);
  }

  @Override
  public int hashCode() {
    return Objects.hash(count, export, seats);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{\n");
    
    sb.append("\"count\": \"").append(toIndentedString(count)).append("\",\n");
    sb.append("\"export\": \"").append(toIndentedString(export)).append("\",\n");
    sb.append("\"seats\": ").append(toIndentedString(seats)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

