package com.sfnt.ldk.model;

import java.util.Objects;

/**
 * FeatureInfo
 */
public class FeatureInfo {
	private Concurrency concurrency = null;
	private Boolean detachable = null;
	private Boolean disabled = null;
	private Boolean expired = null;
	private Integer featureId = null;
	private Integer productId = null;
	private Long keyId = null;
	private LicenseInfo licenseInfo = null;
	private Boolean locked = null;
	private String name = null;
	private Boolean usable = null;
	private Boolean vmEnabled = null;

	public FeatureInfo concurrency(Concurrency concurrency) {
		this.concurrency = concurrency;
		return this;
	}

	/**
	 * Get concurrency
	 * 
	 * @return concurrency
	 **/
	public Concurrency getConcurrency() {
		return concurrency;
	}

	public void setConcurrency(Concurrency concurrency) {
		this.concurrency = concurrency;
	}

	public FeatureInfo detachable(Boolean detachable) {
		this.detachable = detachable;
		return this;
	}

	/**
	 * Get detachable
	 * 
	 * @return detachable
	 **/
	public Boolean isDetachable() {
		return detachable;
	}

	public void setDetachable(Boolean detachable) {
		this.detachable = detachable;
	}

	public FeatureInfo disabled(Boolean disabled) {
		this.disabled = disabled;
		return this;
	}

	/**
	 * Get disabled
	 * 
	 * @return disabled
	 **/
	public Boolean isDisabled() {
		return disabled;
	}

	public void setDisabled(Boolean disabled) {
		this.disabled = disabled;
	}

	public FeatureInfo expired(Boolean expired) {
		this.expired = expired;
		return this;
	}

	/**
	 * Get expired
	 * 
	 * @return expired
	 **/
	public Boolean isExpired() {
		return expired;
	}

	public void setExpired(Boolean expired) {
		this.expired = expired;
	}

	public FeatureInfo featureId(Integer featureId) {
		this.featureId = featureId;
		return this;
	}

	/**
	 * Get featureId
	 * 
	 * @return featureId
	 **/
	public Integer getFeatureId() {
		return featureId;
	}

	public void setFeatureId(Integer featureId) {
		this.featureId = featureId;
	}

	public FeatureInfo productId(Integer productId) {
		this.productId = productId;
		return this;
	}

	/**
	 * Get productId
	 * 
	 * @return productId
	 **/
	public Integer getProductId() {
		return productId;
	}

	public void setProductId(Integer productId) {
		this.productId = productId;
	}

	public FeatureInfo keyId(Long keyId) {
		this.keyId = keyId;
		return this;
	}

	/**
	 * Get keyId
	 * 
	 * @return keyId
	 **/
	public Long getKeyId() {
		return keyId;
	}

	public void setKeyId(Long keyId) {
		this.keyId = keyId;
	}

	public FeatureInfo licenseInfo(LicenseInfo licenseInfo) {
		this.licenseInfo = licenseInfo;
		return this;
	}

	/**
	 * Get licenseInfo
	 * 
	 * @return licenseInfo
	 **/
	public LicenseInfo getLicenseInfo() {
		return licenseInfo;
	}

	public void setLicenseInfo(LicenseInfo licenseInfo) {
		this.licenseInfo = licenseInfo;
	}

	public FeatureInfo locked(Boolean locked) {
		this.locked = locked;
		return this;
	}

	/**
	 * Get locked
	 * 
	 * @return locked
	 **/
	public Boolean isLocked() {
		return locked;
	}

	public void setLocked(Boolean locked) {
		this.locked = locked;
	}

	public FeatureInfo name(String name) {
		this.name = name;
		return this;
	}

	/**
	 * Get name
	 * 
	 * @return name
	 **/
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public FeatureInfo usable(Boolean usable) {
		this.usable = usable;
		return this;
	}

	/**
	 * Get usable
	 * 
	 * @return usable
	 **/
	public Boolean isUsable() {
		return usable;
	}

	public void setUsable(Boolean usable) {
		this.usable = usable;
	}

	public FeatureInfo vmEnabled(Boolean vmEnabled) {
		this.vmEnabled = vmEnabled;
		return this;
	}

	/**
	 * Get vmEnabled
	 * 
	 * @return vmEnabled
	 **/
	public Boolean isvmEnabled() {
		return vmEnabled;
	}

	public void setvmEnabled(Boolean vmEnabled) {
		this.vmEnabled = vmEnabled;
	}

	@Override
	public boolean equals(java.lang.Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		FeatureInfo featureInfo = (FeatureInfo) o;
		return Objects.equals(this.concurrency, featureInfo.concurrency)
				&& Objects.equals(this.detachable, featureInfo.detachable)
				&& Objects.equals(this.disabled, featureInfo.disabled)
				&& Objects.equals(this.expired, featureInfo.expired)
				&& Objects.equals(this.featureId, featureInfo.featureId)
				&& Objects.equals(this.productId, featureInfo.productId)
				&& Objects.equals(this.keyId, featureInfo.keyId)
				&& Objects.equals(this.licenseInfo, featureInfo.licenseInfo)
				&& Objects.equals(this.locked, featureInfo.locked) && Objects.equals(this.name, featureInfo.name)
				&& Objects.equals(this.usable, featureInfo.usable)
				&& Objects.equals(this.vmEnabled, featureInfo.vmEnabled);
	}

	@Override
	public int hashCode() {
		return Objects.hash(concurrency, detachable, disabled, expired, featureId, productId, keyId, licenseInfo,
				locked, name, usable, vmEnabled);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("{\n");

		sb.append("\"concurrency\": ").append(toIndentedString(concurrency)).append(",\n");
		sb.append("\"detachable\": ").append(toIndentedString(detachable)).append(",\n");
		sb.append("\"disabled\": ").append(toIndentedString(disabled)).append(",\n");
		sb.append("\"expired\": ").append(toIndentedString(expired)).append(",\n");
		sb.append("\"featureId\": ").append(toIndentedString(featureId)).append(",\n");
		if(productId != null)
			sb.append("\"productId\": ").append(toIndentedString(productId)).append(",\n");
		if(keyId != null)
			sb.append("\"keyId\": ").append(toIndentedString(keyId)).append(",\n");
		sb.append("\"licenseInfo\": ").append(toIndentedString(licenseInfo)).append(",\n");
		sb.append("\"locked\": ").append(toIndentedString(locked)).append(",\n");
		sb.append("\"name\": \"").append(toIndentedString(name)).append("\",\n");
		sb.append("\"usable\": ").append(toIndentedString(usable)).append(",\n");
		sb.append("\"vmEnabled\": ").append(toIndentedString(vmEnabled)).append("\n");
		sb.append("}");
		return sb.toString();
	}

	/**
	 * Convert the given object to string with each line indented by 4 spaces
	 * (except the first line).
	 */
	private String toIndentedString(java.lang.Object o) {
		if (o == null) {
			return "null";
		}
		return o.toString().replace("\n", "\n    ");
	}

}
