package com.sfnt.ldk.model;

import java.util.Objects;

/**
 * KeyInfo
 */
public class KeyInfo {
  private Boolean attached = null;
  private Boolean cloneProtected = null;
  private String configuration = null;
  private Boolean detachable = null;
  private Boolean disabled = null;
  private Boolean driverless = null;
  private Boolean fingerprintChanged = null;
  private String formFactor = null;
  private Boolean haspEnabled = null;
  private String hwPlatform = null;
  private String hwVersion = null;
  private String keyId = null;
  private String keyModel = null;
  private String keyType = null;
  private String productionDateTime = null;
  private String recipient = null;
  private Boolean rehost = null;
  private String type = null;
  private Integer updateCounter = null;
  private Boolean vclockEnabled = null;
  private String version = null;

  public KeyInfo attached(Boolean attached) {
    this.attached = attached;
    return this;
  }

   /**
   * Get attached
   * @return attached
  **/
  public Boolean isAttached() {
    return attached;
  }

  public void setAttached(Boolean attached) {
    this.attached = attached;
  }

  public KeyInfo cloneProtected(Boolean cloneProtected) {
    this.cloneProtected = cloneProtected;
    return this;
  }

   /**
   * Get cloneProtected
   * @return cloneProtected
  **/
  public Boolean isCloneProtected() {
    return cloneProtected;
  }

  public void setCloneProtected(Boolean cloneProtected) {
    this.cloneProtected = cloneProtected;
  }

  public KeyInfo _configuration(String configuration) {
    this.configuration = configuration;
    return this;
  }

   /**
   * Get _configuration
   * @return _configuration
  **/
  public String getConfiguration() {
    return configuration;
  }

  public void setConfiguration(String configuration) {
    this.configuration = configuration;
  }

  public KeyInfo detachable(Boolean detachable) {
    this.detachable = detachable;
    return this;
  }

   /**
   * Get detachable
   * @return detachable
  **/
  public Boolean isDetachable() {
    return detachable;
  }

  public void setDetachable(Boolean detachable) {
    this.detachable = detachable;
  }

  public KeyInfo disabled(Boolean disabled) {
    this.disabled = disabled;
    return this;
  }

   /**
   * Get disabled
   * @return disabled
  **/
  public Boolean isDisabled() {
    return disabled;
  }

  public void setDisabled(Boolean disabled) {
    this.disabled = disabled;
  }

  public KeyInfo driverless(Boolean driverless) {
    this.driverless = driverless;
    return this;
  }

   /**
   * Get driverless
   * @return driverless
  **/
  public Boolean isDriverless() {
    return driverless;
  }

  public void setDriverless(Boolean driverless) {
    this.driverless = driverless;
  }

  public KeyInfo fingerprintChanged(Boolean fingerprintChanged) {
    this.fingerprintChanged = fingerprintChanged;
    return this;
  }

   /**
   * Get fingerprintChanged
   * @return fingerprintChanged
  **/
  public Boolean isFingerprintChanged() {
    return fingerprintChanged;
  }

  public void setFingerprintChanged(Boolean fingerprintChanged) {
    this.fingerprintChanged = fingerprintChanged;
  }

  public KeyInfo formFactor(String formFactor) {
    this.formFactor = formFactor;
    return this;
  }

   /**
   * Get formFactor
   * @return formFactor
  **/
  public String getFormFactor() {
    return formFactor;
  }

  public void setFormFactor(String formFactor) {
    this.formFactor = formFactor;
  }

  public KeyInfo haspEnabled(Boolean haspEnabled) {
    this.haspEnabled = haspEnabled;
    return this;
  }

   /**
   * Get haspEnabled
   * @return haspEnabled
  **/
  public Boolean isHaspEnabled() {
    return haspEnabled;
  }

  public void setHaspEnabled(Boolean haspEnabled) {
    this.haspEnabled = haspEnabled;
  }

  public KeyInfo hwPlatform(String hwPlatform) {
    this.hwPlatform = hwPlatform;
    return this;
  }

   /**
   * Get hwPlatform
   * @return hwPlatform
  **/
  public String getHwPlatform() {
    return hwPlatform;
  }

  public void setHwPlatform(String hwPlatform) {
    this.hwPlatform = hwPlatform;
  }

  public KeyInfo hwVersion(String hwVersion) {
    this.hwVersion = hwVersion;
    return this;
  }

   /**
   * Get hwVersion
   * @return hwVersion
  **/
  public String getHwVersion() {
    return hwVersion;
  }

  public void setHwVersion(String hwVersion) {
    this.hwVersion = hwVersion;
  }

  public KeyInfo keyId(String keyId) {
    this.keyId = keyId;
    return this;
  }

   /**
   * Get keyId
   * @return keyId
  **/
  public String getKeyId() {
    return keyId;
  }

  public void setKeyId(String keyId) {
    this.keyId = keyId;
  }

  public KeyInfo keyModel(String keyModel) {
    this.keyModel = keyModel;
    return this;
  }

   /**
   * Get keyModel
   * @return keyModel
  **/
  public String getKeyModel() {
    return keyModel;
  }

  public void setKeyModel(String keyModel) {
    this.keyModel = keyModel;
  }

  public KeyInfo keyType(String keyType) {
    this.keyType = keyType;
    return this;
  }

   /**
   * Get keyType
   * @return keyType
  **/
  public String getKeyType() {
    return keyType;
  }

  public void setKeyType(String keyType) {
    this.keyType = keyType;
  }

  public KeyInfo productionDateTime(String productionDateTime) {
    this.productionDateTime = productionDateTime;
    return this;
  }

   /**
   * Get productionDateTime
   * @return productionDateTime
  **/
  public String getProductionDateTime() {
    return productionDateTime;
  }

  public void setProductionDateTime(String productionDateTime) {
    this.productionDateTime = productionDateTime;
  }

  public KeyInfo recipient(String recipient) {
    this.recipient = recipient;
    return this;
  }

   /**
   * Get recipient
   * @return recipient
  **/
  public String getRecipient() {
    return recipient;
  }

  public void setRecipient(String recipient) {
    this.recipient = recipient;
  }

  public KeyInfo rehost(Boolean rehost) {
    this.rehost = rehost;
    return this;
  }

   /**
   * Get rehost
   * @return rehost
  **/
  public Boolean isRehost() {
    return rehost;
  }

  public void setRehost(Boolean rehost) {
    this.rehost = rehost;
  }

  public KeyInfo type(String type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public KeyInfo updateCounter(Integer updateCounter) {
    this.updateCounter = updateCounter;
    return this;
  }

   /**
   * Get updateCounter
   * @return updateCounter
  **/
  public Integer getUpdateCounter() {
    return updateCounter;
  }

  public void setUpdateCounter(Integer updateCounter) {
    this.updateCounter = updateCounter;
  }

  public KeyInfo vclockEnabled(Boolean vclockEnabled) {
    this.vclockEnabled = vclockEnabled;
    return this;
  }

   /**
   * Get vclockEnabled
   * @return vclockEnabled
  **/
  public Boolean isVclockEnabled() {
    return vclockEnabled;
  }

  public void setVclockEnabled(Boolean vclockEnabled) {
    this.vclockEnabled = vclockEnabled;
  }

  public KeyInfo version(String version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    KeyInfo keyInfo = (KeyInfo) o;
    return Objects.equals(this.attached, keyInfo.attached) &&
        Objects.equals(this.cloneProtected, keyInfo.cloneProtected) &&
        Objects.equals(this.configuration, keyInfo.configuration) &&
        Objects.equals(this.detachable, keyInfo.detachable) &&
        Objects.equals(this.disabled, keyInfo.disabled) &&
        Objects.equals(this.driverless, keyInfo.driverless) &&
        Objects.equals(this.fingerprintChanged, keyInfo.fingerprintChanged) &&
        Objects.equals(this.formFactor, keyInfo.formFactor) &&
        Objects.equals(this.haspEnabled, keyInfo.haspEnabled) &&
        Objects.equals(this.hwPlatform, keyInfo.hwPlatform) &&
        Objects.equals(this.hwVersion, keyInfo.hwVersion) &&
        Objects.equals(this.keyId, keyInfo.keyId) &&
        Objects.equals(this.keyModel, keyInfo.keyModel) &&
        Objects.equals(this.keyType, keyInfo.keyType) &&
        Objects.equals(this.productionDateTime, keyInfo.productionDateTime) &&
        Objects.equals(this.recipient, keyInfo.recipient) &&
        Objects.equals(this.rehost, keyInfo.rehost) &&
        Objects.equals(this.type, keyInfo.type) &&
        Objects.equals(this.updateCounter, keyInfo.updateCounter) &&
        Objects.equals(this.vclockEnabled, keyInfo.vclockEnabled) &&
        Objects.equals(this.version, keyInfo.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attached, cloneProtected, configuration, detachable, disabled, driverless, fingerprintChanged, formFactor, haspEnabled, hwPlatform, hwVersion, keyId, keyModel, keyType, productionDateTime, recipient, rehost, type, updateCounter, vclockEnabled, version);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{\n");
    
    sb.append("\"attached\": ").append(toIndentedString(attached)).append(",\n");
    sb.append("\"cloneProtected\": ").append(toIndentedString(cloneProtected)).append(",\n");
    sb.append("\"configuration\": \"").append(toIndentedString(configuration)).append("\",\n");
    sb.append("\"detachable\": ").append(toIndentedString(detachable)).append(",\n");
    sb.append("\"disabled\": ").append(toIndentedString(disabled)).append(",\n");
    sb.append("\"driverless\": ").append(toIndentedString(driverless)).append(",\n");
    sb.append("\"fingerprintChanged\": ").append(toIndentedString(fingerprintChanged)).append(",\n");
    sb.append("\"formFactor\": \"").append(toIndentedString(formFactor)).append("\",\n");
    sb.append("\"haspEnabled\": ").append(toIndentedString(haspEnabled)).append(",\n");
    sb.append("\"hwPlatform\": \"").append(toIndentedString(hwPlatform)).append("\",\n");
    sb.append("\"hwVersion\": \"").append(toIndentedString(hwVersion)).append("\",\n");
    sb.append("\"keyId\": ").append(toIndentedString(keyId)).append(",\n");
    sb.append("\"keyModel\": \"").append(toIndentedString(keyModel)).append("\",\n");
    sb.append("\"keyType\": \"").append(toIndentedString(keyType)).append("\",\n");
    sb.append("\"productionDateTime\": ").append(toIndentedString(productionDateTime)).append(",\n");
    sb.append("\"recipient\": ").append(toIndentedString(recipient)).append(",\n");
    sb.append("\"rehost\": ").append(toIndentedString(rehost)).append(",\n");
    sb.append("\"type\": \"").append(toIndentedString(type)).append("\",\n");
    sb.append("\"updateCounter\": ").append(toIndentedString(updateCounter)).append(",\n");
    sb.append("\"vclockEnabled\": ").append(toIndentedString(vclockEnabled)).append(",\n");
    sb.append("\"version\": \"").append(toIndentedString(version)).append("\"\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

