package com.sfnt.ldk.model;

import java.util.Objects;

/**
 * LicenseInfo
 */
public class LicenseInfo {
	private Integer totalCounter = null;
	private Integer currentCounter = null;
	private String expirationDateTime = null;
	private String startDateTime = null;
	private Integer totalDuration = null;
	private String type = null;

	public LicenseInfo totalCounter(Integer totalCounter) {
		this.totalCounter = totalCounter;
		return this;
	}

	/**
	 * Get totalCounter
	 * 
	 * @return totalCounter
	 **/
	public Integer getTotalCounter() {
		return totalCounter;
	}

	public void setTotalCounter(Integer totalCounter) {
		this.totalCounter = totalCounter;
	}

	public LicenseInfo currentCounter(Integer currentCounter) {
		this.currentCounter = currentCounter;
		return this;
	}

	/**
	 * Get currentCounter
	 * 
	 * @return currentCounter
	 **/
	public Integer getCurrentCounter() {
		return currentCounter;
	}

	public void setCurrentCounter(Integer currentCounter) {
		this.currentCounter = currentCounter;
	}

	public LicenseInfo expirationDateTime(String expirationDateTime) {
		this.expirationDateTime = expirationDateTime;
		return this;
	}

	/**
	 * Get expirationDateTime
	 * 
	 * @return expirationDateTime
	 **/
	public String getExpirationDateTime() {
		return expirationDateTime;
	}

	public void setExpirationDateTime(String expirationDateTime) {
		this.expirationDateTime = expirationDateTime;
	}

	public LicenseInfo startDateTime(String startDateTime) {
		this.startDateTime = startDateTime;
		return this;
	}

	/**
	 * Get startDateTime
	 * 
	 * @return startDateTime
	 **/
	public String getStartDateTime() {
		return startDateTime;
	}

	public void setStartDateTime(String startDateTime) {
		this.startDateTime = startDateTime;
	}

	public LicenseInfo totalDuration(Integer totalDuration) {
		this.totalDuration = totalDuration;
		return this;
	}

	/**
	 * Get totalDuration
	 * 
	 * @return totalDuration
	 **/
	public Integer getTotalDuration() {
		return totalDuration;
	}

	public void setTotalDuration(Integer totalDuration) {
		this.totalDuration = totalDuration;
	}

	public LicenseInfo type(String type) {
		this.type = type;
		return this;
	}

	/**
	 * Get type
	 * 
	 * @return type
	 **/
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Override
	public boolean equals(java.lang.Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		LicenseInfo licenseInfo = (LicenseInfo) o;
		return Objects.equals(this.totalCounter, licenseInfo.totalCounter)
				&& Objects.equals(this.currentCounter, licenseInfo.currentCounter)
				&& Objects.equals(this.expirationDateTime, licenseInfo.expirationDateTime)
				&& Objects.equals(this.startDateTime, licenseInfo.startDateTime)
				&& Objects.equals(this.totalDuration, licenseInfo.totalDuration)
				&& Objects.equals(this.type, licenseInfo.type);
	}

	@Override
	public int hashCode() {
		return Objects.hash(totalCounter, currentCounter, expirationDateTime, startDateTime, totalDuration, type);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("{\n");
		if(totalCounter != null)
			sb.append("\"totalCounter\": ").append(toIndentedString(totalCounter)).append(",\n");
		if(currentCounter != null)
			sb.append("\"currentCounter\": ").append(toIndentedString(currentCounter)).append(",\n");
		if(expirationDateTime != null)
			sb.append("\"expirationDateTime\": \"").append(toIndentedString(expirationDateTime)).append("\",\n");
		if(startDateTime != null)
			sb.append("\"startDateTime\": \"").append(toIndentedString(startDateTime)).append("\",\n");
		if(totalDuration != null)
			sb.append("\"totalDuration\": ").append(toIndentedString(totalDuration)).append(",\n");
		sb.append("\"type\": \"").append(toIndentedString(type)).append("\"\n");
		sb.append("}");
		return sb.toString();
	}

	/**
	 * Convert the given object to string with each line indented by 4 spaces
	 * (except the first line).
	 */
	private String toIndentedString(java.lang.Object o) {
		if (o == null) {
			return "null";
		}
		return o.toString().replace("\n", "\n    ");
	}

}
