package com.sfnt.ldk.model;

import java.util.Objects;

/**
 * LicenseRequest
 */
public class LicenseRequest {
  private Integer featureId = null;
  private ClientInfo clientInfo = null;
  private Scope scope = null;
  private Boolean dieAtExpiration = null;
  private Integer executionCountToConsume = null;
  private Integer networkSeatsToConsume = null;
  private Boolean fullInfo = null;

  public LicenseRequest featureId(Integer featureId) {
    this.featureId = featureId;
    return this;
  }

   /**
   * Get featureId
   * @return featureId
  **/
  public Integer getFeatureId() {
    return featureId;
  }

  public void setFeatureId(Integer featureId) {
    this.featureId = featureId;
  }

  public LicenseRequest clientInfo(ClientInfo clientInfo) {
    this.clientInfo = clientInfo;
    return this;
  }

   /**
   * Get clientInfo
   * @return clientInfo
  **/
  public ClientInfo getClientInfo() {
    return clientInfo;
  }

  public void setClientInfo(ClientInfo clientInfo) {
    this.clientInfo = clientInfo;
  }

  public LicenseRequest scope(Scope scope) {
    this.scope = scope;
    return this;
  }

   /**
   * Get scope
   * @return scope
  **/
  public Scope getScope() {
    return scope;
  }

  public void setScope(Scope scope) {
    this.scope = scope;
  }

  public LicenseRequest dieAtExpiration(Boolean dieAtExpiration) {
    this.dieAtExpiration = dieAtExpiration;
    return this;
  }

   /**
   * Get dieAtExpiration
   * @return dieAtExpiration
  **/
  public Boolean isDieAtExpiration() {
    return dieAtExpiration;
  }

  public void setDieAtExpiration(Boolean dieAtExpiration) {
    this.dieAtExpiration = dieAtExpiration;
  }

  public LicenseRequest executionCountToConsume(Integer executionCountToConsume) {
    this.executionCountToConsume = executionCountToConsume;
    return this;
  }

   /**
   * Get executionCountToConsume
   * @return executionCountToConsume
  **/
  public Integer getExecutionCountToConsume() {
    return executionCountToConsume;
  }

  public void setExecutionCountToConsume(Integer executionCountToConsume) {
    this.executionCountToConsume = executionCountToConsume;
  }

  public LicenseRequest networkSeatsToConsume(Integer networkSeatsToConsume) {
    this.networkSeatsToConsume = networkSeatsToConsume;
    return this;
  }

   /**
   * Get networkSeatsToConsume
   * @return networkSeatsToConsume
  **/
  public Integer getNetworkSeatsToConsume() {
    return networkSeatsToConsume;
  }

  public void setNetworkSeatsToConsume(Integer networkSeatsToConsume) {
    this.networkSeatsToConsume = networkSeatsToConsume;
  }

  /**
  * Get fullInfo
  * @return fullInfo
 **/
 public Boolean isFullInfo() {
   return fullInfo;
 }

 public void setFullInfo(Boolean fullInfo) {
   this.fullInfo = fullInfo;
 }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LicenseRequest licenseRequest = (LicenseRequest) o;
    return Objects.equals(this.featureId, licenseRequest.featureId) &&
        Objects.equals(this.clientInfo, licenseRequest.clientInfo) &&
        Objects.equals(this.scope, licenseRequest.scope) &&
        Objects.equals(this.dieAtExpiration, licenseRequest.dieAtExpiration) &&
        Objects.equals(this.executionCountToConsume, licenseRequest.executionCountToConsume) &&
        Objects.equals(this.networkSeatsToConsume, licenseRequest.networkSeatsToConsume);
  }

  @Override
  public int hashCode() {
    return Objects.hash(featureId, clientInfo, scope, dieAtExpiration, executionCountToConsume, networkSeatsToConsume);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{\n");
    
    sb.append("\"featureId\": ").append(toIndentedString(featureId)).append(",\n");
    sb.append("\"clientInfo\": ").append(toIndentedString(clientInfo)).append(",\n");
    if(scope != null)
    	sb.append("\"scope\": ").append(toIndentedString(scope)).append("\n");
    if(dieAtExpiration != null)
    	sb.append("\"dieAtExpiration\": ").append(toIndentedString(dieAtExpiration)).append(",\n");
    if(executionCountToConsume != null)
    	sb.append("\"executionCountToConsume\": ").append(toIndentedString(executionCountToConsume)).append(",\n");
    if(networkSeatsToConsume != null)
    	sb.append("\"networkSeatsToConsume\": ").append(toIndentedString(networkSeatsToConsume)).append("\n");
    if(fullInfo != null)
    	sb.append(",\"fullInfo\": ").append(toIndentedString(fullInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString();
  }

}

