package com.sfnt.ldk.model;

import java.util.Objects;


/**
 * LicenseResponse
 */
public class LicenseResponse {
  private String sessionId = null;
  private SessionInfo sessionInfo = null;
  private FeatureInfo featureInfo = null;
  private ProductInfo productInfo = null;
  private LicenseResponseKeyInfo keyInfo = null;
  private String lmAccessToken = null;
  private Integer featureId = null;
  private Integer productId = null;
  private Long keyId = null;

  public LicenseResponse sessionId(String sessionId) {
    this.sessionId = sessionId;
    return this;
  }

   /**
   * Get sessionId
   * @return sessionId
  **/
  public String getSessionId() {
    return sessionId;
  }

  public void setSessionId(String sessionId) {
    this.sessionId = sessionId;
  }

  public LicenseResponse sessionInfo(SessionInfo sessionInfo) {
    this.sessionInfo = sessionInfo;
    return this;
  }

   /**
   * Get sessionInfo
   * @return sessionInfo
  **/
  public SessionInfo getSessionInfo() {
    return sessionInfo;
  }

  public void setSessionInfo(SessionInfo sessionInfo) {
    this.sessionInfo = sessionInfo;
  }

  public LicenseResponse featureInfo(FeatureInfo featureInfo) {
    this.featureInfo = featureInfo;
    return this;
  }

   /**
   * Get featureInfo
   * @return featureInfo
  **/
  public FeatureInfo getFeatureInfo() {
    return featureInfo;
  }

  public void setFeatureInfo(FeatureInfo featureInfo) {
    this.featureInfo = featureInfo;
  }

  public LicenseResponse productInfo(ProductInfo productInfo) {
    this.productInfo = productInfo;
    return this;
  }

   /**
   * Get productInfo
   * @return productInfo
  **/
  public ProductInfo getProductInfo() {
    return productInfo;
  }

  public void setProductInfo(ProductInfo productInfo) {
    this.productInfo = productInfo;
  }

  public LicenseResponse keyInfo(LicenseResponseKeyInfo keyInfo) {
    this.keyInfo = keyInfo;
    return this;
  }

   /**
   * Get keyInfo
   * @return keyInfo
  **/
  public LicenseResponseKeyInfo getKeyInfo() {
    return keyInfo;
  }

  public void setKeyInfo(LicenseResponseKeyInfo keyInfo) {
    this.keyInfo = keyInfo;
  }

	/**
	 * Get featureId
	 * 
	 * @return featureId
	 **/
	public Integer getFeatureId() {
		return featureId;
	}

	public void setFeatureId(Integer featureId) {
		this.featureId = featureId;
	}

	/**
	 * Get productId
	 * 
	 * @return productId
	 **/
	public Integer getProductId() {
		return productId;
	}

	public void setProductId(Integer productId) {
		this.productId = productId;
	}

	/**
	 * Get keyId
	 * 
	 * @return keyId
	 **/
	public Long getKeyId() {
		return keyId;
	}

	public void setKeyId(Long keyId) {
		this.keyId = keyId;
	}
	
	public LicenseResponse lmAccessToken(String lmAccessToken) {
	    this.lmAccessToken = lmAccessToken;
	    return this;
	  }

	   /**
	   * Get lmAccessToken
	   * @return lmAccessToken
	  **/
	  public String getLmAccessToken() {
	    return lmAccessToken;
	  }

	  public void setLmAccessToken(String lmAccessToken) {
	    this.lmAccessToken = lmAccessToken;
	  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LicenseResponse licenseResponse = (LicenseResponse) o;
    return Objects.equals(this.sessionId, licenseResponse.sessionId) &&
        Objects.equals(this.sessionInfo, licenseResponse.sessionInfo) &&
        Objects.equals(this.featureInfo, licenseResponse.featureInfo) &&
        Objects.equals(this.productInfo, licenseResponse.productInfo) &&
        Objects.equals(this.keyInfo, licenseResponse.keyInfo) &&
        Objects.equals(this.lmAccessToken, licenseResponse.lmAccessToken);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sessionId, sessionInfo, featureInfo, productInfo, keyInfo, lmAccessToken);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{\n");
    
    sb.append("\"sessionId\": \"").append(toIndentedString(sessionId)).append("\",\n");
    sb.append("\"sessionInfo\": ").append(toIndentedString(sessionInfo)).append(",\n");
    if(featureInfo != null)
    	sb.append("\"featureInfo\": ").append(toIndentedString(featureInfo)).append(",\n");
    if(productInfo != null)
    	sb.append("\"productInfo\": ").append(toIndentedString(productInfo)).append(",\n");
    if(keyInfo != null)
    	sb.append("\"keyInfo\": ").append(toIndentedString(keyInfo)).append(",\n");
    if(featureId != null)
    	sb.append("\"featureId\": ").append(toIndentedString(featureId)).append(",\n");
    if(productId != null)
    	sb.append("\"productId\": ").append(toIndentedString(productId)).append(",\n");
    if(keyId != null)
    	sb.append("\"keyId\": ").append(toIndentedString(keyId)).append(",\n");
    if(lmAccessToken != null) {
    	sb.append("\"lmAccessToken\": ").append(toIndentedString(lmAccessToken)).append("\n");
    } else {
    	sb.deleteCharAt(sb.length() - 2);
    }
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

