package com.sfnt.ldk.model;

import java.util.Objects;

/**
 * LicenseResponseKeyInfo
 */
public class LicenseResponseKeyInfo {
  private Long keyId = null;

  public LicenseResponseKeyInfo id(Long keyId) {
    this.keyId = keyId;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  public Long getKeyId() {
    return keyId;
  }

  public void setKeyId(Long keyId) {
    this.keyId = keyId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LicenseResponseKeyInfo licenseResponseKeyInfo = (LicenseResponseKeyInfo) o;
    return Objects.equals(this.keyId, licenseResponseKeyInfo.keyId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(keyId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{\n");
    
    sb.append("\"keyId\": ").append(toIndentedString(keyId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

