package com.sfnt.ldk.model;

import java.util.Objects;

/**
 * LogoutResponse
 */
public class LogoutResponse {
	private Integer errorCode = null;
	private String message = null;

	public LogoutResponse errorCode(Integer errorCode) {
		this.errorCode = errorCode;
		return this;
	}

	/**
	 * The error code
	 * 
	 * @return errorCode
	 **/
	public Integer getErrorCode() {
		return errorCode;
	}

	public void setErrorCode(Integer errorCode) {
		this.errorCode = errorCode;
	}

	public LogoutResponse message(String message) {
		this.message = message;
		return this;
	}

	/**
	 * Description of error code
	 * 
	 * @return message
	 **/
	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	@Override
	public boolean equals(java.lang.Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		LogoutResponse response = (LogoutResponse) o;
		return Objects.equals(this.errorCode, response.errorCode) && Objects.equals(this.message, response.message);
	}

	@Override
	public int hashCode() {
		return Objects.hash(errorCode, message);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("{\n");

		sb.append("\"errorCode\": ").append(toIndentedString(errorCode));
		if (message != null)
			sb.append(",\n\"message\": \"").append(toIndentedString(message)).append("\"\n");
		sb.append("\n}");
		return sb.toString();
	}

	/**
	 * Convert the given object to string with each line indented by 4 spaces
	 * (except the first line).
	 */
	private String toIndentedString(java.lang.Object o) {
		if (o == null) {
			return "null";
		}
		return o.toString().replace("\n", "\n    ");
	}

}
