package com.sfnt.ldk.model;

import java.util.Objects;

/**
 * MemoryInfo
 */
public class MemoryInfo {
  private Integer memoryId = null;
  private Integer size = null;
  private String attribute = null;
  private Long keyId = null;

  public MemoryInfo memoryId(Integer memoryId) {
    this.memoryId = memoryId;
    return this;
  }

   /**
   * Get memoryId
   * @return memoryId
  **/
  public Integer getMemoryId() {
    return memoryId;
  }

  public void setMemoryId(Integer memoryId) {
    this.memoryId = memoryId;
  }

  public MemoryInfo size(Integer size) {
    this.size = size;
    return this;
  }

   /**
   * Get size
   * @return size
  **/
  public Integer getSize() {
    return size;
  }

  public void setSize(Integer size) {
    this.size = size;
  }

  public MemoryInfo attribute(String attribute) {
    this.attribute = attribute;
    return this;
  }

   /**
   * Get attribute
   * @return attribute
  **/
  public String getAttribute() {
    return attribute;
  }

  public void setAttribute(String attribute) {
    this.attribute = attribute;
  }

  public MemoryInfo keyId(Long keyId) {
    this.keyId = keyId;
    return this;
  }

   /**
   * Get keyId
   * @return keyId
  **/
  public Long getKeyId() {
    return keyId;
  }

  public void setKeyId(Long keyId) {
    this.keyId = keyId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MemoryInfo memoryInfo = (MemoryInfo) o;
    return Objects.equals(this.memoryId, memoryInfo.memoryId) &&
        Objects.equals(this.size, memoryInfo.size) &&
        Objects.equals(this.attribute, memoryInfo.attribute) &&
        Objects.equals(this.keyId, memoryInfo.keyId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(memoryId, size, attribute, keyId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{\n");
    
    sb.append("    memoryId: ").append(toIndentedString(memoryId)).append(",\n");
    sb.append("    size: ").append(toIndentedString(size)).append(",\n");
    sb.append("    attribute: ").append(toIndentedString(attribute)).append(",\n");
    sb.append("    keyId: ").append(toIndentedString(keyId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

