package com.sfnt.ldk.model;

import java.util.Objects;

/**
 * ProductInfo
 */
public class ProductInfo {
  private Boolean cloneProtected = null;
  private Boolean detachable = null;
  private Boolean fingerprintChanged = null;
  private Integer productId = null;
  private Long keyId = null;
  private String name = null;

  public ProductInfo cloneProtected(Boolean cloneProtected) {
    this.cloneProtected = cloneProtected;
    return this;
  }

   /**
   * Get cloneProtected
   * @return cloneProtected
  **/
  public Boolean isCloneProtected() {
    return cloneProtected;
  }

  public void setCloneProtected(Boolean cloneProtected) {
    this.cloneProtected = cloneProtected;
  }

  public ProductInfo detachable(Boolean detachable) {
    this.detachable = detachable;
    return this;
  }

   /**
   * Whether the license for the Product can be detached from the network pool.
   * @return detachable
  **/
  public Boolean isDetachable() {
    return detachable;
  }

  public void setDetachable(Boolean detachable) {
    this.detachable = detachable;
  }

  public ProductInfo fingerprintChanged(Boolean fingerprintChanged) {
    this.fingerprintChanged = fingerprintChanged;
    return this;
  }

   /**
   * Get fingerprintChanged
   * @return fingerprintChanged
  **/
  public Boolean isFingerprintChanged() {
    return fingerprintChanged;
  }

  public void setFingerprintChanged(Boolean fingerprintChanged) {
    this.fingerprintChanged = fingerprintChanged;
  }

  public ProductInfo productId(Integer productId) {
    this.productId = productId;
    return this;
  }

   /**
   * Get productId
   * @return productId
  **/
  public Integer getProductId() {
    return productId;
  }

  public void setProductId(Integer productId) {
    this.productId = productId;
  }

  public ProductInfo keyId(Long keyId) {
    this.keyId = keyId;
    return this;
  }

   /**
   * Get keyId
   * @return keyId
  **/
  public Long getKeyId() {
    return keyId;
  }

  public void setKeyId(Long keyId) {
    this.keyId = keyId;
  }

  public ProductInfo name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProductInfo productInfo = (ProductInfo) o;
    return Objects.equals(this.cloneProtected, productInfo.cloneProtected) &&
        Objects.equals(this.detachable, productInfo.detachable) &&
        Objects.equals(this.fingerprintChanged, productInfo.fingerprintChanged) &&
        Objects.equals(this.productId, productInfo.productId) &&
        Objects.equals(this.keyId, productInfo.keyId) &&
        Objects.equals(this.name, productInfo.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cloneProtected, detachable, fingerprintChanged, productId, keyId, name);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{\n");
    
    sb.append("\"cloneProtected\": ").append(toIndentedString(cloneProtected)).append(",\n");
    sb.append("\"detachable\": ").append(toIndentedString(detachable)).append(",\n");
    sb.append("\"fingerprintChanged\": ").append(toIndentedString(fingerprintChanged)).append(",\n");
    sb.append("\"productId\": ").append(toIndentedString(productId)).append(",\n");
    if(keyId != null)
    	sb.append("\"keyId\": ").append(toIndentedString(keyId)).append(",\n");
    sb.append("\"name\": \"").append(toIndentedString(name)).append("\"\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

