package com.sfnt.ldk.model;

import java.util.Objects;
/**
 * MemoryResponse
 */
public class ReadMemoryResponse {
  private String content = null;

  public ReadMemoryResponse content(String content) {
    this.content = content;
    return this;
  }

   /**
   * base-64 format Memory content
   * @return content
  **/
  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReadMemoryResponse memoryResponse = (ReadMemoryResponse) o;
    return Objects.equals(this.content, memoryResponse.content);
  }

  @Override
  public int hashCode() {
    return Objects.hash(content);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{\n");
    
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

