package com.sfnt.ldk.model;

import java.util.Objects;
import java.util.ArrayList;
import java.util.List;

/**
 * Scope
 */
public class Scope {
  private List<String> keyId = null;
  private List<Integer> productId = null;

  public Scope keyId(List<String> keyId) {
    this.keyId = keyId;
    return this;
  }

  public Scope addKeyIdItem(String keyIdItem) {
    if (this.keyId == null) {
      this.keyId = new ArrayList<>();
    }
    this.keyId.add(keyIdItem);
    return this;
  }

   /**
   * Get keyId
   * @return keyId
  **/
  public List<String> getKeyId() {
    return keyId;
  }

  public void setKeyId(List<String> keyId) {
    this.keyId = keyId;
  }

  public Scope productId(List<Integer> productId) {
    this.productId = productId;
    return this;
  }

  public Scope addProductIdItem(Integer productIdItem) {
    if (this.productId == null) {
      this.productId = new ArrayList<>();
    }
    this.productId.add(productIdItem);
    return this;
  }

   /**
   * Get productId
   * @return productId
  **/
  public List<Integer> getProductId() {
    return productId;
  }

  public void setProductId(List<Integer> productId) {
    this.productId = productId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Scope scope = (Scope) o;
    return Objects.equals(this.keyId, scope.keyId) &&
        Objects.equals(this.productId, scope.productId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(keyId, productId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{\n");
    
    sb.append("\"keyId\": ").append(toIndentedString(keyId)).append(",\n");
    sb.append("\"productId\": ").append(toIndentedString(productId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

