package com.sfnt.ldk.model;

import java.util.Objects;

/**
 * SessionInfo
 */
public class SessionInfo {
  private Integer currentLogins = null;
  private Integer idleTimeout = null;

  public SessionInfo currentLogins(Integer currentLogins) {
    this.currentLogins = currentLogins;
    return this;
  }

   /**
   * Number of current logins to the Feature/application.
   * @return currentLogins
  **/
  public Integer getcurrentLogins() {
    return currentLogins;
  }

  public void setCurrentlogins(Integer currentLogins) {
    this.currentLogins = currentLogins;
  }

  public SessionInfo idleTimeout(Integer idleTimeout) {
    this.idleTimeout = idleTimeout;
    return this;
  }

   /**
   * Total amount of time (in seconds) that the session can be idle before it is terminated.
   * @return idleTimeout
  **/
  public Integer getIdleTimeout() {
    return idleTimeout;
  }

  public void setIdleTimeout(Integer idleTimeout) {
    this.idleTimeout = idleTimeout;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SessionInfo sessionInfo = (SessionInfo) o;
    return Objects.equals(this.currentLogins, sessionInfo.currentLogins) &&
        Objects.equals(this.idleTimeout, sessionInfo.idleTimeout);
  }

  @Override
  public int hashCode() {
    return Objects.hash(currentLogins, idleTimeout);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{\n");
    
    sb.append("\"currentLogins\": ").append(toIndentedString(currentLogins)).append(",\n");
    sb.append("\"idleTimeout\": ").append(toIndentedString(idleTimeout)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

